/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;

class CompositeTextMapPropagator
implements TextMapPropagator {
    private final Collection<TextMapPropagator> injectors;
    private final Collection<TextMapPropagator> extractors;
    private final TextMapPropagator baggagePropagator;
    private final Set<String> fields;

    CompositeTextMapPropagator(Collection<TextMapPropagator> injectors, Collection<TextMapPropagator> mutuallyExclusiveExtractors, TextMapPropagator baggagePropagator) {
        this.injectors = injectors;
        this.extractors = mutuallyExclusiveExtractors;
        this.baggagePropagator = baggagePropagator;
        LinkedHashSet fields = new LinkedHashSet();
        this.fields(this.injectors).forEach(fields::add);
        this.fields(this.extractors).forEach(fields::add);
        if (baggagePropagator != null) {
            fields.addAll(baggagePropagator.fields());
        }
        this.fields = Collections.unmodifiableSet(fields);
    }

    private Stream<String> fields(Collection<TextMapPropagator> propagators) {
        return propagators.stream().flatMap(propagator -> propagator.fields().stream());
    }

    Collection<TextMapPropagator> getInjectors() {
        return this.injectors;
    }

    Collection<TextMapPropagator> getExtractors() {
        return this.extractors;
    }

    public Collection<String> fields() {
        return this.fields;
    }

    public <C> void inject(Context context, C carrier, TextMapSetter<C> setter2) {
        if (context != null && setter2 != null) {
            this.injectors.forEach(injector -> injector.inject(context, carrier, setter2));
        }
    }

    public <C> Context extract(Context context, C carrier, TextMapGetter<C> getter2) {
        if (context == null) {
            return Context.root();
        }
        if (getter2 == null) {
            return context;
        }
        Context result = this.extractors.stream().map(extractor -> extractor.extract(context, carrier, getter2)).filter(extracted -> extracted != context).findFirst().orElse(context);
        if (this.baggagePropagator != null) {
            result = this.baggagePropagator.extract(result, carrier, getter2);
        }
        return result;
    }

    static TextMapPropagator create(TracingProperties.Propagation properties, TextMapPropagator baggagePropagator) {
        TextMapPropagatorMapper mapper = new TextMapPropagatorMapper(baggagePropagator != null);
        List injectors = properties.getEffectiveProducedTypes().stream().map(mapper::map).collect(Collectors.toCollection(ArrayList::new));
        if (baggagePropagator != null) {
            injectors.add(baggagePropagator);
        }
        List<TextMapPropagator> extractors = properties.getEffectiveConsumedTypes().stream().map(mapper::map).toList();
        return new CompositeTextMapPropagator(injectors, extractors, baggagePropagator);
    }

    private static class TextMapPropagatorMapper {
        private final boolean baggage;

        TextMapPropagatorMapper(boolean baggage) {
            this.baggage = baggage;
        }

        TextMapPropagator map(TracingProperties.Propagation.PropagationType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case TracingProperties.Propagation.PropagationType.B3 -> this.b3Single();
                case TracingProperties.Propagation.PropagationType.B3_MULTI -> this.b3Multi();
                case TracingProperties.Propagation.PropagationType.W3C -> this.w3c();
            };
        }

        private TextMapPropagator b3Single() {
            return B3Propagator.injectingSingleHeader();
        }

        private TextMapPropagator b3Multi() {
            return B3Propagator.injectingMultiHeaders();
        }

        private TextMapPropagator w3c() {
            return !this.baggage ? W3CTraceContextPropagator.getInstance() : TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance()});
        }
    }
}

