/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.annotation.Reflective;
import org.springframework.aot.hint.annotation.ReflectiveRuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.servlet.AbstractWebMvcEndpointHandlerMapping;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;

@ImportRuntimeHints(value={WebMvcEndpointHandlerMappingRuntimeHints.class})
public class WebMvcEndpointHandlerMapping
extends AbstractWebMvcEndpointHandlerMapping {
    private final EndpointLinksResolver linksResolver;

    public WebMvcEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration, EndpointLinksResolver linksResolver, boolean shouldRegisterLinksMapping) {
        super(endpointMapping, endpoints, endpointMediaTypes, corsConfiguration, shouldRegisterLinksMapping);
        this.linksResolver = linksResolver;
        this.setOrder(-100);
    }

    @Override
    protected AbstractWebMvcEndpointHandlerMapping.LinksHandler getLinksHandler() {
        return new WebMvcLinksHandler();
    }

    class WebMvcLinksHandler
    implements AbstractWebMvcEndpointHandlerMapping.LinksHandler {
        WebMvcLinksHandler() {
        }

        @Override
        @ResponseBody
        @Reflective
        public Map<String, Map<String, Link>> links(HttpServletRequest request, HttpServletResponse response) {
            Map<String, Link> links = WebMvcEndpointHandlerMapping.this.linksResolver.resolveLinks(request.getRequestURL().toString());
            return OperationResponseBody.of(Collections.singletonMap("_links", links));
        }

        public String toString() {
            return "Actuator root web endpoint";
        }
    }

    static class WebMvcEndpointHandlerMappingRuntimeHints
    implements RuntimeHintsRegistrar {
        private final ReflectiveRuntimeHintsRegistrar reflectiveRegistrar = new ReflectiveRuntimeHintsRegistrar();
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        WebMvcEndpointHandlerMappingRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            this.reflectiveRegistrar.registerRuntimeHints(hints, WebMvcLinksHandler.class);
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Link.class});
        }
    }
}

