/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.pulsar;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.interceptor.ProducerInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.pulsar.PulsarConfiguration;
import org.springframework.boot.autoconfigure.pulsar.PulsarProperties;
import org.springframework.boot.autoconfigure.pulsar.PulsarPropertiesMapper;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.VirtualThreadTaskExecutor;
import org.springframework.pulsar.annotation.EnablePulsar;
import org.springframework.pulsar.config.ConcurrentPulsarListenerContainerFactory;
import org.springframework.pulsar.config.DefaultPulsarReaderContainerFactory;
import org.springframework.pulsar.core.CachingPulsarProducerFactory;
import org.springframework.pulsar.core.ConsumerBuilderCustomizer;
import org.springframework.pulsar.core.DefaultPulsarConsumerFactory;
import org.springframework.pulsar.core.DefaultPulsarProducerFactory;
import org.springframework.pulsar.core.DefaultPulsarReaderFactory;
import org.springframework.pulsar.core.ProducerBuilderCustomizer;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.core.PulsarProducerFactory;
import org.springframework.pulsar.core.PulsarReaderFactory;
import org.springframework.pulsar.core.PulsarTemplate;
import org.springframework.pulsar.core.ReaderBuilderCustomizer;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.pulsar.reader.PulsarReaderContainerProperties;

@AutoConfiguration
@ConditionalOnClass(value={PulsarClient.class, PulsarTemplate.class})
@Import(value={PulsarConfiguration.class})
public class PulsarAutoConfiguration {
    private final PulsarProperties properties;
    private final PulsarPropertiesMapper propertiesMapper;

    PulsarAutoConfiguration(PulsarProperties properties) {
        this.properties = properties;
        this.propertiesMapper = new PulsarPropertiesMapper(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarProducerFactory.class})
    @ConditionalOnProperty(name={"spring.pulsar.producer.cache.enabled"}, havingValue="false")
    DefaultPulsarProducerFactory<?> pulsarProducerFactory(PulsarClient pulsarClient, TopicResolver topicResolver, ObjectProvider<ProducerBuilderCustomizer<?>> customizersProvider) {
        List<ProducerBuilderCustomizer<Object>> lambdaSafeCustomizers = this.lambdaSafeProducerBuilderCustomizers(customizersProvider);
        return new DefaultPulsarProducerFactory(pulsarClient, this.properties.getProducer().getTopicName(), lambdaSafeCustomizers, topicResolver);
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarProducerFactory.class})
    @ConditionalOnProperty(name={"spring.pulsar.producer.cache.enabled"}, havingValue="true", matchIfMissing=true)
    CachingPulsarProducerFactory<?> cachingPulsarProducerFactory(PulsarClient pulsarClient, TopicResolver topicResolver, ObjectProvider<ProducerBuilderCustomizer<?>> customizersProvider) {
        PulsarProperties.Producer.Cache cacheProperties = this.properties.getProducer().getCache();
        List<ProducerBuilderCustomizer<Object>> lambdaSafeCustomizers = this.lambdaSafeProducerBuilderCustomizers(customizersProvider);
        return new CachingPulsarProducerFactory(pulsarClient, this.properties.getProducer().getTopicName(), lambdaSafeCustomizers, topicResolver, cacheProperties.getExpireAfterAccess(), Long.valueOf(cacheProperties.getMaximumSize()), Integer.valueOf(cacheProperties.getInitialCapacity()));
    }

    private List<ProducerBuilderCustomizer<Object>> lambdaSafeProducerBuilderCustomizers(ObjectProvider<ProducerBuilderCustomizer<?>> customizersProvider) {
        ArrayList<Object> customizers = new ArrayList<Object>();
        customizers.add(this.propertiesMapper::customizeProducerBuilder);
        customizers.addAll(customizersProvider.orderedStream().toList());
        return List.of(builder -> this.applyProducerBuilderCustomizers(customizers, builder));
    }

    private void applyProducerBuilderCustomizers(List<ProducerBuilderCustomizer<?>> customizers, ProducerBuilder<?> builder) {
        LambdaSafe.callbacks(ProducerBuilderCustomizer.class, customizers, builder, new Object[0]).invoke(customizer2 -> customizer2.customize(builder));
    }

    @Bean
    @ConditionalOnMissingBean
    PulsarTemplate<?> pulsarTemplate(PulsarProducerFactory<?> pulsarProducerFactory, ObjectProvider<ProducerInterceptor> producerInterceptors, SchemaResolver schemaResolver, TopicResolver topicResolver) {
        return new PulsarTemplate(pulsarProducerFactory, producerInterceptors.orderedStream().toList(), schemaResolver, topicResolver, this.properties.getTemplate().isObservationsEnabled());
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarConsumerFactory.class})
    DefaultPulsarConsumerFactory<?> pulsarConsumerFactory(PulsarClient pulsarClient, ObjectProvider<ConsumerBuilderCustomizer<?>> customizersProvider) {
        ArrayList<Object> customizers = new ArrayList<Object>();
        customizers.add(this.propertiesMapper::customizeConsumerBuilder);
        customizers.addAll(customizersProvider.orderedStream().toList());
        List<ConsumerBuilderCustomizer> lambdaSafeCustomizers = List.of(builder -> this.applyConsumerBuilderCustomizers(customizers, builder));
        return new DefaultPulsarConsumerFactory(pulsarClient, lambdaSafeCustomizers);
    }

    private void applyConsumerBuilderCustomizers(List<ConsumerBuilderCustomizer<?>> customizers, ConsumerBuilder<?> builder) {
        LambdaSafe.callbacks(ConsumerBuilderCustomizer.class, customizers, builder, new Object[0]).invoke(customizer2 -> customizer2.customize(builder));
    }

    @Bean
    @ConditionalOnMissingBean(name={"pulsarListenerContainerFactory"})
    ConcurrentPulsarListenerContainerFactory<?> pulsarListenerContainerFactory(PulsarConsumerFactory<Object> pulsarConsumerFactory, SchemaResolver schemaResolver, TopicResolver topicResolver, Environment environment2) {
        PulsarContainerProperties containerProperties = new PulsarContainerProperties(new String[0]);
        containerProperties.setSchemaResolver(schemaResolver);
        containerProperties.setTopicResolver(topicResolver);
        if (Threading.VIRTUAL.isActive(environment2)) {
            containerProperties.setConsumerTaskExecutor((AsyncTaskExecutor)new VirtualThreadTaskExecutor("pulsar-consumer-"));
        }
        this.propertiesMapper.customizeContainerProperties(containerProperties);
        return new ConcurrentPulsarListenerContainerFactory(pulsarConsumerFactory, containerProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarReaderFactory.class})
    DefaultPulsarReaderFactory<?> pulsarReaderFactory(PulsarClient pulsarClient, ObjectProvider<ReaderBuilderCustomizer<?>> customizersProvider) {
        ArrayList<Object> customizers = new ArrayList<Object>();
        customizers.add(this.propertiesMapper::customizeReaderBuilder);
        customizers.addAll(customizersProvider.orderedStream().toList());
        List<ReaderBuilderCustomizer> lambdaSafeCustomizers = List.of(builder -> this.applyReaderBuilderCustomizers(customizers, builder));
        return new DefaultPulsarReaderFactory(pulsarClient, lambdaSafeCustomizers);
    }

    private void applyReaderBuilderCustomizers(List<ReaderBuilderCustomizer<?>> customizers, ReaderBuilder<?> builder) {
        LambdaSafe.callbacks(ReaderBuilderCustomizer.class, customizers, builder, new Object[0]).invoke(customizer2 -> customizer2.customize(builder));
    }

    @Bean
    @ConditionalOnMissingBean(name={"pulsarReaderContainerFactory"})
    DefaultPulsarReaderContainerFactory<?> pulsarReaderContainerFactory(PulsarReaderFactory<?> pulsarReaderFactory, SchemaResolver schemaResolver, Environment environment2) {
        PulsarReaderContainerProperties readerContainerProperties = new PulsarReaderContainerProperties();
        readerContainerProperties.setSchemaResolver(schemaResolver);
        if (Threading.VIRTUAL.isActive(environment2)) {
            readerContainerProperties.setReaderTaskExecutor((AsyncTaskExecutor)new VirtualThreadTaskExecutor("pulsar-reader-"));
        }
        this.propertiesMapper.customizeReaderContainerProperties(readerContainerProperties);
        return new DefaultPulsarReaderContainerFactory(pulsarReaderFactory, readerContainerProperties);
    }

    @Configuration(proxyBeanMethods=false)
    @EnablePulsar
    @ConditionalOnMissingBean(name={"org.springframework.pulsar.config.internalPulsarListenerAnnotationProcessor", "org.springframework.pulsar.config.internalPulsarReaderAnnotationProcessor"})
    static class EnablePulsarConfiguration {
        EnablePulsarConfiguration() {
        }
    }
}

