/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingSystemProperty;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LoggingSystemProperties {
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String PID_KEY = LoggingSystemProperty.PID.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String EXCEPTION_CONVERSION_WORD = LoggingSystemProperty.EXCEPTION_CONVERSION_WORD.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String LOG_FILE = LoggingSystemProperty.LOG_FILE.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String LOG_PATH = LoggingSystemProperty.LOG_PATH.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String CONSOLE_LOG_PATTERN = LoggingSystemProperty.CONSOLE_PATTERN.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String CONSOLE_LOG_CHARSET = LoggingSystemProperty.CONSOLE_CHARSET.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String CONSOLE_LOG_THRESHOLD = LoggingSystemProperty.CONSOLE_THRESHOLD.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String FILE_LOG_PATTERN = LoggingSystemProperty.FILE_PATTERN.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String FILE_LOG_CHARSET = LoggingSystemProperty.FILE_CHARSET.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String FILE_LOG_THRESHOLD = LoggingSystemProperty.FILE_THRESHOLD.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String LOG_LEVEL_PATTERN = LoggingSystemProperty.LEVEL_PATTERN.getEnvironmentVariableName();
    @Deprecated(since="3.2.0", forRemoval=true)
    public static final String LOG_DATEFORMAT_PATTERN = LoggingSystemProperty.DATEFORMAT_PATTERN.getEnvironmentVariableName();
    private static final BiConsumer<String, String> systemPropertySetter = (name, value) -> {
        if (System.getProperty(name) == null && value != null) {
            System.setProperty(name, value);
        }
    };
    private final Environment environment;
    private final Function<String, String> defaultValueResolver;
    private final BiConsumer<String, String> setter;

    public LoggingSystemProperties(Environment environment2) {
        this(environment2, null);
    }

    public LoggingSystemProperties(Environment environment2, BiConsumer<String, String> setter2) {
        this(environment2, null, setter2);
    }

    public LoggingSystemProperties(Environment environment2, Function<String, String> defaultValueResolver, BiConsumer<String, String> setter2) {
        Assert.notNull((Object)environment2, "Environment must not be null");
        this.environment = environment2;
        this.defaultValueResolver = defaultValueResolver != null ? defaultValueResolver : name -> null;
        this.setter = setter2 != null ? setter2 : systemPropertySetter;
    }

    protected Charset getDefaultCharset() {
        return StandardCharsets.UTF_8;
    }

    public final void apply() {
        this.apply(null);
    }

    public final void apply(LogFile logFile) {
        PropertyResolver resolver = this.getPropertyResolver();
        this.apply(logFile, resolver);
    }

    private PropertyResolver getPropertyResolver() {
        Environment environment2 = this.environment;
        if (environment2 instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment2;
            PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver(configurableEnvironment.getPropertySources());
            resolver.setConversionService(((ConfigurableEnvironment)this.environment).getConversionService());
            resolver.setIgnoreUnresolvableNestedPlaceholders(true);
            return resolver;
        }
        return this.environment;
    }

    protected void apply(LogFile logFile, PropertyResolver resolver) {
        String defaultCharsetName = this.getDefaultCharset().name();
        this.setApplicationNameSystemProperty(resolver);
        this.setSystemProperty(LoggingSystemProperty.PID, new ApplicationPid().toString());
        this.setSystemProperty(LoggingSystemProperty.CONSOLE_CHARSET, resolver, defaultCharsetName);
        this.setSystemProperty(LoggingSystemProperty.FILE_CHARSET, resolver, defaultCharsetName);
        this.setSystemProperty(LoggingSystemProperty.CONSOLE_THRESHOLD, resolver);
        this.setSystemProperty(LoggingSystemProperty.FILE_THRESHOLD, resolver);
        this.setSystemProperty(LoggingSystemProperty.EXCEPTION_CONVERSION_WORD, resolver);
        this.setSystemProperty(LoggingSystemProperty.CONSOLE_PATTERN, resolver);
        this.setSystemProperty(LoggingSystemProperty.FILE_PATTERN, resolver);
        this.setSystemProperty(LoggingSystemProperty.LEVEL_PATTERN, resolver);
        this.setSystemProperty(LoggingSystemProperty.DATEFORMAT_PATTERN, resolver);
        this.setSystemProperty(LoggingSystemProperty.CORRELATION_PATTERN, resolver);
        if (logFile != null) {
            logFile.applyToSystemProperties();
        }
    }

    private void setApplicationNameSystemProperty(PropertyResolver resolver) {
        String applicationName;
        if (resolver.getProperty("logging.include-application-name", Boolean.class, Boolean.TRUE).booleanValue() && StringUtils.hasText(applicationName = resolver.getProperty("spring.application.name"))) {
            this.setSystemProperty(LoggingSystemProperty.APPLICATION_NAME.getEnvironmentVariableName(), "[%s] ".formatted(applicationName));
        }
    }

    private void setSystemProperty(LoggingSystemProperty property, PropertyResolver resolver) {
        this.setSystemProperty(property, resolver, null);
    }

    private void setSystemProperty(LoggingSystemProperty property, PropertyResolver resolver, String defaultValue) {
        String value = property.getApplicationPropertyName() != null ? resolver.getProperty(property.getApplicationPropertyName()) : null;
        value = value != null ? value : this.defaultValueResolver.apply(property.getApplicationPropertyName());
        value = value != null ? value : defaultValue;
        this.setSystemProperty(property.getEnvironmentVariableName(), value);
    }

    private void setSystemProperty(LoggingSystemProperty property, String value) {
        this.setSystemProperty(property.getEnvironmentVariableName(), value);
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    protected final void setSystemProperty(PropertyResolver resolver, String systemPropertyName, String propertyName) {
        this.setSystemProperty(resolver, systemPropertyName, propertyName, null);
    }

    @Deprecated(since="3.2.0", forRemoval=true)
    protected final void setSystemProperty(PropertyResolver resolver, String systemPropertyName, String propertyName, String defaultValue) {
        String value = resolver.getProperty(propertyName);
        value = value != null ? value : this.defaultValueResolver.apply(systemPropertyName);
        value = value != null ? value : defaultValue;
        this.setSystemProperty(systemPropertyName, value);
    }

    protected final void setSystemProperty(String name, String value) {
        this.setter.accept(name, value);
    }
}

