/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiElement;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.ansi.AnsiStyle;

@Plugin(name="color", category="Converter")
@ConverterKeys(value={"clr", "color"})
public final class ColorConverter
extends LogEventPatternConverter {
    private static final Map<String, AnsiElement> ELEMENTS;
    private static final Map<Integer, AnsiElement> LEVELS;
    private final List<PatternFormatter> formatters;
    private final AnsiElement styling;

    private ColorConverter(List<PatternFormatter> formatters, AnsiElement styling) {
        super("style", "style");
        this.formatters = formatters;
        this.styling = styling;
    }

    public static ColorConverter newInstance(Configuration config, String[] options) {
        if (options.length < 1) {
            LOGGER.error("Incorrect number of options on style. Expected at least 1, received {}", (Object)options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on style");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        List<PatternFormatter> formatters = parser.parse(options[0]);
        AnsiElement element = options.length != 1 ? ELEMENTS.get(options[1]) : null;
        return new ColorConverter(formatters, element);
    }

    @Override
    public boolean handlesThrowable() {
        for (PatternFormatter formatter : this.formatters) {
            if (!formatter.handlesThrowable()) continue;
            return true;
        }
        return super.handlesThrowable();
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : this.formatters) {
            formatter.format(event, buf);
        }
        if (!buf.isEmpty()) {
            AnsiElement element = this.styling;
            if (element == null) {
                element = LEVELS.get(event.getLevel().intLevel());
                element = element != null ? element : AnsiColor.GREEN;
            }
            this.appendAnsiString(toAppendTo, buf.toString(), element);
        }
    }

    protected void appendAnsiString(StringBuilder toAppendTo, String in, AnsiElement element) {
        toAppendTo.append(AnsiOutput.toString(element, in));
    }

    static {
        HashMap<String, Enum> ansiElements = new HashMap<String, Enum>();
        ansiElements.put("black", AnsiColor.BLACK);
        ansiElements.put("white", AnsiColor.WHITE);
        ansiElements.put("faint", AnsiStyle.FAINT);
        ansiElements.put("red", AnsiColor.RED);
        ansiElements.put("green", AnsiColor.GREEN);
        ansiElements.put("yellow", AnsiColor.YELLOW);
        ansiElements.put("blue", AnsiColor.BLUE);
        ansiElements.put("magenta", AnsiColor.MAGENTA);
        ansiElements.put("cyan", AnsiColor.CYAN);
        ansiElements.put("bright_black", AnsiColor.BRIGHT_BLACK);
        ansiElements.put("bright_white", AnsiColor.BRIGHT_WHITE);
        ansiElements.put("bright_red", AnsiColor.BRIGHT_RED);
        ansiElements.put("bright_green", AnsiColor.BRIGHT_GREEN);
        ansiElements.put("bright_yellow", AnsiColor.BRIGHT_YELLOW);
        ansiElements.put("bright_blue", AnsiColor.BRIGHT_BLUE);
        ansiElements.put("bright_magenta", AnsiColor.BRIGHT_MAGENTA);
        ansiElements.put("bright_cyan", AnsiColor.BRIGHT_CYAN);
        ELEMENTS = Collections.unmodifiableMap(ansiElements);
        HashMap<Integer, AnsiColor> ansiLevels = new HashMap<Integer, AnsiColor>();
        ansiLevels.put(Level.FATAL.intLevel(), AnsiColor.RED);
        ansiLevels.put(Level.ERROR.intLevel(), AnsiColor.RED);
        ansiLevels.put(Level.WARN.intLevel(), AnsiColor.YELLOW);
        LEVELS = Collections.unmodifiableMap(ansiLevels);
    }
}

