/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import jakarta.servlet.http.Cookie;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.ListenerHolder;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.ServletMapping;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlet.Source;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebInfConfiguration;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.SetCookieParser;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpCookieUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.session.DefaultSessionCache;
import org.eclipse.jetty.session.FileSessionDataStore;
import org.eclipse.jetty.session.SessionCache;
import org.eclipse.jetty.session.SessionDataStore;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.resource.CombinedResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.URLResourceFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.embedded.jetty.ForwardHeadersCustomizer;
import org.springframework.boot.web.embedded.jetty.JasperInitializer;
import org.springframework.boot.web.embedded.jetty.JettyEmbeddedErrorHandler;
import org.springframework.boot.web.embedded.jetty.JettyEmbeddedWebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyHandlerWrappers;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyWebServer;
import org.springframework.boot.web.embedded.jetty.ServletContextInitializerConfiguration;
import org.springframework.boot.web.embedded.jetty.SslServerCustomizer;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.boot.web.servlet.server.CookieSameSiteSupplier;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JettyServletWebServerFactory
extends AbstractServletWebServerFactory
implements ConfigurableJettyWebServerFactory,
ResourceLoaderAware {
    private List<Configuration> configurations = new ArrayList<Configuration>();
    private boolean useForwardHeaders;
    private int acceptors = -1;
    private int selectors = -1;
    private Set<JettyServerCustomizer> jettyServerCustomizers = new LinkedHashSet<JettyServerCustomizer>();
    private ResourceLoader resourceLoader;
    private ThreadPool threadPool;
    private int maxConnections = -1;

    public JettyServletWebServerFactory() {
    }

    public JettyServletWebServerFactory(int port) {
        super(port);
    }

    public JettyServletWebServerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    @Override
    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        JettyEmbeddedWebAppContext context = new JettyEmbeddedWebAppContext();
        context.getContext().getServletContext().setExtendedListenerTypes(true);
        int port = Math.max(this.getPort(), 0);
        InetSocketAddress address = new InetSocketAddress(this.getAddress(), port);
        Server server = this.createServer(address);
        context.setServer(server);
        this.configureWebAppContext(context, initializers);
        server.setHandler(this.addHandlerWrappers((Handler)context));
        this.logger.info("Server initialized with port: " + port);
        if (this.maxConnections > -1) {
            server.addBean((Object)new ConnectionLimit(this.maxConnections, server.getConnectors()));
        }
        if (Ssl.isEnabled(this.getSsl())) {
            this.customizeSsl(server, address);
        }
        for (JettyServerCustomizer customizer2 : this.getServerCustomizers()) {
            customizer2.customize(server);
        }
        if (this.useForwardHeaders) {
            new ForwardHeadersCustomizer().customize(server);
        }
        if (this.getShutdown() == Shutdown.GRACEFUL) {
            StatisticsHandler statisticsHandler = new StatisticsHandler();
            statisticsHandler.setHandler(server.getHandler());
            server.setHandler((Handler)statisticsHandler);
        }
        return this.getJettyWebServer(server);
    }

    private Server createServer(InetSocketAddress address) {
        Server server = new Server(this.getThreadPool());
        server.setConnectors(new Connector[]{this.createConnector(address, server)});
        server.setStopTimeout(0L);
        MimeTypes.Mutable mimeTypes = server.getMimeTypes();
        for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
            mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
        }
        return server;
    }

    private AbstractConnector createConnector(InetSocketAddress address, Server server) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        ArrayList<Object> connectionFactories = new ArrayList<Object>();
        connectionFactories.add(new HttpConnectionFactory(httpConfiguration));
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connectionFactories.add(new HTTP2CServerConnectionFactory(httpConfiguration));
        }
        ServerConnector connector = new ServerConnector(server, this.acceptors, this.selectors, connectionFactories.toArray(new ConnectionFactory[0]));
        connector.setHost(address.getHostString());
        connector.setPort(address.getPort());
        return connector;
    }

    private Handler addHandlerWrappers(Handler handler) {
        if (this.getCompression() != null && this.getCompression().getEnabled()) {
            handler = this.applyWrapper(handler, JettyHandlerWrappers.createGzipHandlerWrapper(this.getCompression()));
        }
        if (StringUtils.hasText(this.getServerHeader())) {
            handler = this.applyWrapper(handler, JettyHandlerWrappers.createServerHeaderHandlerWrapper(this.getServerHeader()));
        }
        if (!CollectionUtils.isEmpty(this.getCookieSameSiteSuppliers())) {
            handler = this.applyWrapper(handler, new SuppliedSameSiteCookieHandlerWrapper(this.getCookieSameSiteSuppliers()));
        }
        return handler;
    }

    private Handler applyWrapper(Handler handler, Handler.Wrapper wrapper) {
        wrapper.setHandler(handler);
        return wrapper;
    }

    private void customizeSsl(Server server, InetSocketAddress address) {
        new SslServerCustomizer(this.getHttp2(), address, this.getSsl().getClientAuth(), this.getSslBundle()).customize(server);
    }

    protected final void configureWebAppContext(WebAppContext context, ServletContextInitializer ... initializers) {
        String contextPath;
        Assert.notNull((Object)context, "Context must not be null");
        context.clearAliasChecks();
        if (this.resourceLoader != null) {
            context.setClassLoader(this.resourceLoader.getClassLoader());
        }
        context.setContextPath(StringUtils.hasLength(contextPath = this.getContextPath()) ? contextPath : "/");
        context.setDisplayName(this.getDisplayName());
        this.configureDocumentRoot(context);
        if (this.isRegisterDefaultServlet()) {
            this.addDefaultServlet(context);
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet(context);
            context.addBean((Object)new JasperInitializer(context), true);
        }
        this.addLocaleMappings(context);
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        Configuration[] configurations = this.getWebAppContextConfigurations(context, initializersToUse);
        context.setConfigurations(configurations);
        context.setThrowUnavailableOnStartupException(true);
        this.configureSession(context);
        context.setTempDirectory(this.getTempDirectory(context));
        this.postProcessWebAppContext(context);
    }

    private void configureSession(WebAppContext context) {
        Duration sessionTimeout;
        SessionHandler handler = context.getSessionHandler();
        Cookie.SameSite sessionSameSite = this.getSession().getCookie().getSameSite();
        if (sessionSameSite != null) {
            handler.setSameSite(HttpCookie.SameSite.valueOf((String)sessionSameSite.name()));
        }
        handler.setMaxInactiveInterval(this.isNegative(sessionTimeout = this.getSession().getTimeout()) ? -1 : (int)sessionTimeout.getSeconds());
        if (this.getSession().isPersistent()) {
            DefaultSessionCache cache = new DefaultSessionCache((SessionManager)handler);
            FileSessionDataStore store = new FileSessionDataStore();
            store.setStoreDir(this.getValidSessionStoreDir());
            cache.setSessionDataStore((SessionDataStore)store);
            handler.setSessionCache((SessionCache)cache);
        }
    }

    private boolean isNegative(Duration sessionTimeout) {
        return sessionTimeout == null || sessionTimeout.isNegative();
    }

    private void addLocaleMappings(WebAppContext context) {
        this.getLocaleCharsetMappings().forEach((locale, charset) -> context.addLocaleEncoding(locale.toString(), charset.toString()));
    }

    private File getTempDirectory(WebAppContext context) {
        String temp = System.getProperty("java.io.tmpdir");
        return temp != null ? new File(temp, WebInfConfiguration.getCanonicalNameForWebAppTmpDir((WebAppContext)context) + UUID.randomUUID()) : null;
    }

    private void configureDocumentRoot(WebAppContext handler) {
        File root = this.getValidDocumentRoot();
        File docBase = root != null ? root : this.createTempDir("jetty-docbase");
        try {
            ResourceFactory resourceFactory = handler.getResourceFactory();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            Resource rootResource = docBase.isDirectory() ? resourceFactory.newResource(docBase.getCanonicalFile().toURI()) : resourceFactory.newJarFileResource(docBase.toURI());
            resources.add(root != null ? new LoaderHidingResource(rootResource, rootResource) : rootResource);
            URLResourceFactory urlResourceFactory = new URLResourceFactory();
            for (URL resourceJarUrl : this.getUrlsOfJarsWithMetaInfResources()) {
                Resource resource = this.createResource(resourceJarUrl, resourceFactory, urlResourceFactory);
                if (resource == null) continue;
                resources.add(resource);
            }
            handler.setBaseResource(ResourceFactory.combine(resources));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Resource createResource(URL url, ResourceFactory resourceFactory, URLResourceFactory urlResourceFactory) throws Exception {
        if ("file".equals(url.getProtocol())) {
            File file = new File(url.toURI());
            if (file.isFile()) {
                return resourceFactory.newResource("jar:" + url + "!/META-INF/resources/");
            }
            if (file.isDirectory()) {
                return resourceFactory.newResource(url).resolve("META-INF/resources/");
            }
        }
        return urlResourceFactory.newResource(url + "META-INF/resources/");
    }

    protected final void addDefaultServlet(WebAppContext context) {
        Assert.notNull((Object)context, "Context must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("default");
        holder.setClassName("org.eclipse.jetty.ee10.servlet.DefaultServlet");
        holder.setInitParameter("dirAllowed", "false");
        holder.setInitOrder(1);
        context.getServletHandler().addServletWithMapping(holder, "/");
        ServletMapping servletMapping = context.getServletHandler().getServletMapping("/");
        servletMapping.setFromDefaultDescriptor(true);
    }

    protected final void addJspServlet(WebAppContext context) {
        Assert.notNull((Object)context, "Context must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("jsp");
        holder.setClassName(this.getJsp().getClassName());
        holder.setInitParameter("fork", "false");
        holder.setInitParameters(this.getJsp().getInitParameters());
        holder.setInitOrder(3);
        context.getServletHandler().addServlet(holder);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("jsp");
        mapping.setPathSpecs(new String[]{"*.jsp", "*.jspx"});
        context.getServletHandler().addServletMapping(mapping);
    }

    protected Configuration[] getWebAppContextConfigurations(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        ArrayList<Object> configurations = new ArrayList<Object>();
        configurations.add(this.getServletContextInitializerConfiguration(webAppContext, initializers));
        configurations.add(this.getErrorPageConfiguration());
        configurations.add(this.getMimeTypeConfiguration());
        configurations.add((Object)new WebListenersConfiguration(this.getWebListenerClassNames()));
        configurations.addAll(this.getConfigurations());
        return configurations.toArray(new Configuration[0]);
    }

    private Configuration getErrorPageConfiguration() {
        return new AbstractConfiguration(new AbstractConfiguration.Builder()){

            public void configure(WebAppContext context) throws Exception {
                JettyEmbeddedErrorHandler errorHandler = new JettyEmbeddedErrorHandler();
                context.setErrorHandler((Request.Handler)errorHandler);
                JettyServletWebServerFactory.this.addJettyErrorPages((ErrorHandler)errorHandler, JettyServletWebServerFactory.this.getErrorPages());
            }
        };
    }

    private Configuration getMimeTypeConfiguration() {
        return new AbstractConfiguration(new AbstractConfiguration.Builder()){

            public void configure(WebAppContext context) throws Exception {
                MimeTypes.Wrapper mimeTypes = (MimeTypes.Wrapper)context.getMimeTypes();
                mimeTypes.setWrapped(new MimeTypes(null));
                for (MimeMappings.Mapping mapping : JettyServletWebServerFactory.this.getMimeMappings()) {
                    mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
                }
            }
        };
    }

    protected Configuration getServletContextInitializerConfiguration(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        return new ServletContextInitializerConfiguration(initializers);
    }

    protected void postProcessWebAppContext(WebAppContext webAppContext) {
    }

    protected JettyWebServer getJettyWebServer(Server server) {
        return new JettyWebServer(server, this.getPort() >= 0);
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    @Override
    public void setAcceptors(int acceptors) {
        this.acceptors = acceptors;
    }

    @Override
    public void setSelectors(int selectors) {
        this.selectors = selectors;
    }

    @Override
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setServerCustomizers(Collection<? extends JettyServerCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        this.jettyServerCustomizers = new LinkedHashSet<JettyServerCustomizer>(customizers);
    }

    public Collection<JettyServerCustomizer> getServerCustomizers() {
        return this.jettyServerCustomizers;
    }

    @Override
    public void addServerCustomizers(JettyServerCustomizer ... customizers) {
        Assert.notNull((Object)customizers, "Customizers must not be null");
        this.jettyServerCustomizers.addAll(Arrays.asList(customizers));
    }

    public void setConfigurations(Collection<? extends Configuration> configurations) {
        Assert.notNull(configurations, "Configurations must not be null");
        this.configurations = new ArrayList<Configuration>(configurations);
    }

    public Collection<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void addConfigurations(Configuration ... configurations) {
        Assert.notNull((Object)configurations, "Configurations must not be null");
        this.configurations.addAll(Arrays.asList(configurations));
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    @Override
    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    private void addJettyErrorPages(ErrorHandler errorHandler, Collection<ErrorPage> errorPages) {
        if (errorHandler instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler handler = (ErrorPageErrorHandler)errorHandler;
            for (ErrorPage errorPage : errorPages) {
                if (errorPage.isGlobal()) {
                    handler.addErrorPage("org.eclipse.jetty.server.error_page.global", errorPage.getPath());
                    continue;
                }
                if (errorPage.getExceptionName() != null) {
                    handler.addErrorPage(errorPage.getExceptionName(), errorPage.getPath());
                    continue;
                }
                handler.addErrorPage(errorPage.getStatusCode(), errorPage.getPath());
            }
        }
    }

    private static class SuppliedSameSiteCookieHandlerWrapper
    extends Handler.Wrapper {
        private static final SetCookieParser setCookieParser = SetCookieParser.newInstance();
        private final List<CookieSameSiteSupplier> suppliers;

        SuppliedSameSiteCookieHandlerWrapper(List<CookieSameSiteSupplier> suppliers) {
            this.suppliers = suppliers;
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            SuppliedSameSiteCookieResponse wrappedResponse = new SuppliedSameSiteCookieResponse(request, response);
            return super.handle(request, (Response)wrappedResponse, callback);
        }

        private class SuppliedSameSiteCookieResponse
        extends Response.Wrapper {
            private HttpFields.Mutable wrappedHeaders;

            SuppliedSameSiteCookieResponse(Request request, Response wrapped) {
                super(request, wrapped);
                this.wrappedHeaders = new SuppliedSameSiteCookieHeaders(request.getConnectionMetaData().getHttpConfiguration().getResponseCookieCompliance(), wrapped.getHeaders());
            }

            public HttpFields.Mutable getHeaders() {
                return this.wrappedHeaders;
            }
        }

        private class SuppliedSameSiteCookieHeaders
        extends HttpFields.Mutable.Wrapper {
            private final CookieCompliance compliance;

            SuppliedSameSiteCookieHeaders(CookieCompliance compliance, HttpFields.Mutable fields) {
                super(fields);
                this.compliance = compliance;
            }

            public HttpField onAddField(HttpField field2) {
                return field2.getHeader() != HttpHeader.SET_COOKIE ? field2 : this.onAddSetCookieField(field2);
            }

            private HttpField onAddSetCookieField(HttpField field2) {
                Cookie.SameSite sameSite;
                HttpCookie cookie = setCookieParser.parse(field2.getValue());
                Cookie.SameSite sameSite2 = sameSite = cookie != null ? this.getSameSite(cookie) : null;
                if (sameSite == null) {
                    return field2;
                }
                HttpCookie updatedCookie = this.buildCookieWithUpdatedSameSite(cookie, sameSite);
                return new HttpCookieUtils.SetCookieHttpField(updatedCookie, this.compliance);
            }

            private HttpCookie buildCookieWithUpdatedSameSite(HttpCookie cookie, Cookie.SameSite sameSite) {
                return HttpCookie.build((HttpCookie)cookie).sameSite(HttpCookie.SameSite.from((String)sameSite.name())).build();
            }

            private Cookie.SameSite getSameSite(HttpCookie cookie) {
                return this.getSameSite(this.asServletCookie(cookie));
            }

            private Cookie.SameSite getSameSite(Cookie cookie) {
                return SuppliedSameSiteCookieHandlerWrapper.this.suppliers.stream().map(supplier -> supplier.getSameSite(cookie)).filter(Objects::nonNull).findFirst().orElse(null);
            }

            private Cookie asServletCookie(HttpCookie cookie) {
                Cookie servletCookie = new Cookie(cookie.getName(), cookie.getValue());
                cookie.getAttributes().forEach((arg_0, arg_1) -> ((Cookie)servletCookie).setAttribute(arg_0, arg_1));
                return servletCookie;
            }
        }
    }

    private static final class LoaderHidingResource
    extends Resource {
        private static final String LOADER_RESOURCE_PATH_PREFIX = "/org/springframework/boot/";
        private final Resource base;
        private final Resource delegate;

        private LoaderHidingResource(Resource base, Resource delegate) {
            this.base = base;
            this.delegate = delegate;
        }

        public void forEach(Consumer<? super Resource> action) {
            this.delegate.forEach(action);
        }

        public Path getPath() {
            return this.delegate.getPath();
        }

        public boolean isContainedIn(Resource r) {
            return this.delegate.isContainedIn(r);
        }

        public Iterator<Resource> iterator() {
            if (this.delegate instanceof CombinedResource) {
                return this.list().iterator();
            }
            return List.of(this).iterator();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean exists() {
            return this.delegate.exists();
        }

        public Spliterator<Resource> spliterator() {
            return this.delegate.spliterator();
        }

        public boolean isDirectory() {
            return this.delegate.isDirectory();
        }

        public boolean isReadable() {
            return this.delegate.isReadable();
        }

        public Instant lastModified() {
            return this.delegate.lastModified();
        }

        public long length() {
            return this.delegate.length();
        }

        public URI getURI() {
            return this.delegate.getURI();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public String getFileName() {
            return this.delegate.getFileName();
        }

        public InputStream newInputStream() throws IOException {
            return this.delegate.newInputStream();
        }

        public ReadableByteChannel newReadableByteChannel() throws IOException {
            return this.delegate.newReadableByteChannel();
        }

        public List<Resource> list() {
            return this.delegate.list().stream().filter(this::nonLoaderResource).toList();
        }

        private boolean nonLoaderResource(Resource resource) {
            Path prefix = this.base.getPath().resolve(Path.of("org", "springframework", "boot"));
            return !resource.getPath().startsWith(prefix);
        }

        public Resource resolve(String subUriPath) {
            if (subUriPath.startsWith(LOADER_RESOURCE_PATH_PREFIX)) {
                return null;
            }
            Resource resolved = this.delegate.resolve(subUriPath);
            return resolved != null ? new LoaderHidingResource(this.base, resolved) : null;
        }

        public boolean isAlias() {
            return this.delegate.isAlias();
        }

        public URI getRealURI() {
            return this.delegate.getRealURI();
        }

        public void copyTo(Path destination) throws IOException {
            this.delegate.copyTo(destination);
        }

        public Collection<Resource> getAllResources() {
            return this.delegate.getAllResources().stream().filter(this::nonLoaderResource).toList();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class WebListenersConfiguration
    extends AbstractConfiguration {
        private final Set<String> classNames;

        WebListenersConfiguration(Set<String> webListenerClassNames) {
            super(new AbstractConfiguration.Builder());
            this.classNames = webListenerClassNames;
        }

        public void configure(WebAppContext context) throws Exception {
            ServletHandler servletHandler = context.getServletHandler();
            for (String className : this.classNames) {
                this.configure(context, servletHandler, className);
            }
        }

        private void configure(WebAppContext context, ServletHandler servletHandler, String className) throws ClassNotFoundException {
            ListenerHolder holder = servletHandler.newListenerHolder(new Source(Source.Origin.ANNOTATION, className));
            holder.setHeldClass(this.loadClass(context, className));
            servletHandler.addListener(holder);
        }

        private Class<? extends EventListener> loadClass(WebAppContext context, String className) throws ClassNotFoundException {
            ClassLoader classLoader = context.getClassLoader();
            classLoader = classLoader != null ? classLoader : ((Object)((Object)this)).getClass().getClassLoader();
            return classLoader.loadClass(className);
        }
    }
}

