/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aot.generate.AccessControl;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.support.ClassHintUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.InitDestroyAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ResourceElementResolver;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.jndi.support.SimpleJndiBeanFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class CommonAnnotationBeanPostProcessor
extends InitDestroyAnnotationBeanPostProcessor
implements InstantiationAwareBeanPostProcessor,
BeanFactoryAware,
Serializable {
    private static final boolean jndiPresent = ClassUtils.isPresent("javax.naming.InitialContext", CommonAnnotationBeanPostProcessor.class.getClassLoader());
    private static final Set<Class<? extends Annotation>> resourceAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>(4);
    @Nullable
    private static final Class<? extends Annotation> jakartaResourceType = CommonAnnotationBeanPostProcessor.loadAnnotationType("jakarta.annotation.Resource");
    @Nullable
    private static final Class<? extends Annotation> javaxResourceType;
    @Nullable
    private static final Class<? extends Annotation> ejbAnnotationType;
    private final Set<String> ignoredResourceTypes = new HashSet<String>(1);
    private boolean fallbackToDefaultTypeMatch = true;
    private boolean alwaysUseJndiLookup = false;
    @Nullable
    private transient BeanFactory jndiFactory;
    @Nullable
    private transient BeanFactory resourceFactory;
    @Nullable
    private transient BeanFactory beanFactory;
    @Nullable
    private transient StringValueResolver embeddedValueResolver;
    private final transient Map<String, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap<String, InjectionMetadata>(256);

    public CommonAnnotationBeanPostProcessor() {
        this.setOrder(0x7FFFFFFC);
        this.addInitAnnotationType(CommonAnnotationBeanPostProcessor.loadAnnotationType("jakarta.annotation.PostConstruct"));
        this.addDestroyAnnotationType(CommonAnnotationBeanPostProcessor.loadAnnotationType("jakarta.annotation.PreDestroy"));
        this.addInitAnnotationType(CommonAnnotationBeanPostProcessor.loadAnnotationType("javax.annotation.PostConstruct"));
        this.addDestroyAnnotationType(CommonAnnotationBeanPostProcessor.loadAnnotationType("javax.annotation.PreDestroy"));
        if (jndiPresent) {
            this.jndiFactory = new SimpleJndiBeanFactory();
        }
    }

    public void ignoreResourceType(String resourceType) {
        Assert.notNull((Object)resourceType, "Ignored resource type must not be null");
        this.ignoredResourceTypes.add(resourceType);
    }

    public void setFallbackToDefaultTypeMatch(boolean fallbackToDefaultTypeMatch) {
        this.fallbackToDefaultTypeMatch = fallbackToDefaultTypeMatch;
    }

    public void setAlwaysUseJndiLookup(boolean alwaysUseJndiLookup) {
        this.alwaysUseJndiLookup = alwaysUseJndiLookup;
    }

    public void setJndiFactory(BeanFactory jndiFactory) {
        Assert.notNull((Object)jndiFactory, "BeanFactory must not be null");
        this.jndiFactory = jndiFactory;
    }

    public void setResourceFactory(BeanFactory resourceFactory) {
        Assert.notNull((Object)resourceFactory, "BeanFactory must not be null");
        this.resourceFactory = resourceFactory;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, "BeanFactory must not be null");
        this.beanFactory = beanFactory;
        if (this.resourceFactory == null) {
            this.resourceFactory = beanFactory;
        }
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
            this.embeddedValueResolver = new EmbeddedValueResolver(configurableBeanFactory);
        }
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        super.postProcessMergedBeanDefinition(beanDefinition, beanType, beanName);
        InjectionMetadata metadata = this.findResourceMetadata(beanName, beanType, null);
        metadata.checkConfigMembers(beanDefinition);
    }

    @Override
    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        RootBeanDefinition beanDefinition;
        BeanRegistrationAotContribution parentAotContribution = super.processAheadOfTime(registeredBean);
        Class<?> beanClass = registeredBean.getBeanClass();
        String beanName = registeredBean.getBeanName();
        InjectionMetadata metadata = this.findResourceMetadata(beanName, beanClass, (beanDefinition = registeredBean.getMergedBeanDefinition()).getPropertyValues());
        Collection<LookupElement> injectedElements = this.getInjectedElements(metadata, beanDefinition.getPropertyValues());
        if (!ObjectUtils.isEmpty(injectedElements)) {
            AotContribution aotContribution = new AotContribution(beanClass, injectedElements, this.getAutowireCandidateResolver(registeredBean));
            return BeanRegistrationAotContribution.concat(parentAotContribution, aotContribution);
        }
        return parentAotContribution;
    }

    @Nullable
    private AutowireCandidateResolver getAutowireCandidateResolver(RegisteredBean registeredBean) {
        ConfigurableListableBeanFactory configurableListableBeanFactory = registeredBean.getBeanFactory();
        if (configurableListableBeanFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory lbf = (DefaultListableBeanFactory)configurableListableBeanFactory;
            return lbf.getAutowireCandidateResolver();
        }
        return null;
    }

    private Collection<LookupElement> getInjectedElements(InjectionMetadata metadata, PropertyValues propertyValues) {
        return metadata.getInjectedElements(propertyValues);
    }

    @Override
    public void resetBeanDefinition(String beanName) {
        this.injectionMetadataCache.remove(beanName);
    }

    @Override
    @Nullable
    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) {
        return null;
    }

    @Override
    public boolean postProcessAfterInstantiation(Object bean2, String beanName) {
        return true;
    }

    @Override
    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean2, String beanName) {
        InjectionMetadata metadata = this.findResourceMetadata(beanName, bean2.getClass(), pvs);
        try {
            metadata.inject(bean2, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of resource dependencies failed", ex);
        }
        return pvs;
    }

    public void processInjection(Object bean2) throws BeanCreationException {
        Class<?> clazz = bean2.getClass();
        InjectionMetadata metadata = this.findResourceMetadata(clazz.getName(), clazz, null);
        try {
            metadata.inject(bean2, null, null);
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException("Injection of resource dependencies failed for class [" + clazz + "]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findResourceMetadata(String beanName, Class<?> clazz, @Nullable PropertyValues pvs) {
        String cacheKey = StringUtils.hasLength(beanName) ? beanName : clazz.getName();
        InjectionMetadata metadata = this.injectionMetadataCache.get(cacheKey);
        if (InjectionMetadata.needsRefresh(metadata, clazz)) {
            Map<String, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(cacheKey);
                if (InjectionMetadata.needsRefresh(metadata, clazz)) {
                    if (metadata != null) {
                        metadata.clear(pvs);
                    }
                    metadata = this.buildResourceMetadata(clazz);
                    this.injectionMetadataCache.put(cacheKey, metadata);
                }
            }
        }
        return metadata;
    }

    private InjectionMetadata buildResourceMetadata(Class<?> clazz) {
        if (!AnnotationUtils.isCandidateClass(clazz, resourceAnnotationTypes)) {
            return InjectionMetadata.EMPTY;
        }
        ArrayList<InjectionMetadata.InjectedElement> elements = new ArrayList<InjectionMetadata.InjectedElement>();
        Class<?> targetClass = clazz;
        do {
            ArrayList currElements = new ArrayList();
            ReflectionUtils.doWithLocalFields(targetClass, field2 -> {
                if (ejbAnnotationType != null && field2.isAnnotationPresent(ejbAnnotationType)) {
                    if (Modifier.isStatic(field2.getModifiers())) {
                        throw new IllegalStateException("@EJB annotation is not supported on static fields");
                    }
                    currElements.add(new EjbRefElement(field2, field2, null));
                } else if (jakartaResourceType != null && field2.isAnnotationPresent(jakartaResourceType)) {
                    if (Modifier.isStatic(field2.getModifiers())) {
                        throw new IllegalStateException("@Resource annotation is not supported on static fields");
                    }
                    if (!this.ignoredResourceTypes.contains(field2.getType().getName())) {
                        currElements.add(new ResourceElement(field2, field2, null));
                    }
                } else if (javaxResourceType != null && field2.isAnnotationPresent(javaxResourceType)) {
                    if (Modifier.isStatic(field2.getModifiers())) {
                        throw new IllegalStateException("@Resource annotation is not supported on static fields");
                    }
                    if (!this.ignoredResourceTypes.contains(field2.getType().getName())) {
                        currElements.add(new LegacyResourceElement(field2, field2, null));
                    }
                }
            });
            ReflectionUtils.doWithLocalMethods(targetClass, method -> {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod(method);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair(method, bridgedMethod)) {
                    return;
                }
                if (ejbAnnotationType != null && bridgedMethod.isAnnotationPresent(ejbAnnotationType)) {
                    if (method.equals(ClassUtils.getMostSpecificMethod(method, clazz))) {
                        if (Modifier.isStatic(method.getModifiers())) {
                            throw new IllegalStateException("@EJB annotation is not supported on static methods");
                        }
                        if (method.getParameterCount() != 1) {
                            throw new IllegalStateException("@EJB annotation requires a single-arg method: " + method);
                        }
                        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(bridgedMethod, clazz);
                        currElements.add(new EjbRefElement(method, bridgedMethod, pd));
                    }
                } else if (jakartaResourceType != null && bridgedMethod.isAnnotationPresent(jakartaResourceType)) {
                    if (method.equals(ClassUtils.getMostSpecificMethod(method, clazz))) {
                        if (Modifier.isStatic(method.getModifiers())) {
                            throw new IllegalStateException("@Resource annotation is not supported on static methods");
                        }
                        Class<?>[] paramTypes = method.getParameterTypes();
                        if (paramTypes.length != 1) {
                            throw new IllegalStateException("@Resource annotation requires a single-arg method: " + method);
                        }
                        if (!this.ignoredResourceTypes.contains(paramTypes[0].getName())) {
                            PropertyDescriptor pd = BeanUtils.findPropertyForMethod(bridgedMethod, clazz);
                            currElements.add(new ResourceElement(method, bridgedMethod, pd));
                        }
                    }
                } else if (javaxResourceType != null && bridgedMethod.isAnnotationPresent(javaxResourceType) && method.equals(ClassUtils.getMostSpecificMethod(method, clazz))) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("@Resource annotation is not supported on static methods");
                    }
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length != 1) {
                        throw new IllegalStateException("@Resource annotation requires a single-arg method: " + method);
                    }
                    if (!this.ignoredResourceTypes.contains(paramTypes[0].getName())) {
                        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(bridgedMethod, clazz);
                        currElements.add(new LegacyResourceElement(method, bridgedMethod, pd));
                    }
                }
            });
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return InjectionMetadata.forElements(elements, clazz);
    }

    protected Object buildLazyResourceProxy(final LookupElement element, final @Nullable String requestingBeanName) {
        ClassLoader classLoader;
        BeanFactory beanFactory;
        TargetSource ts = new TargetSource(){

            @Override
            public Class<?> getTargetClass() {
                return element.lookupType;
            }

            @Override
            public Object getTarget() {
                return CommonAnnotationBeanPostProcessor.this.getResource(element, requestingBeanName);
            }
        };
        ProxyFactory pf = new ProxyFactory();
        pf.setTargetSource(ts);
        if (element.lookupType.isInterface()) {
            pf.addInterface(element.lookupType);
        }
        if ((beanFactory = this.beanFactory) instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
            classLoader = configurableBeanFactory.getBeanClassLoader();
        } else {
            classLoader = null;
        }
        ClassLoader classLoader2 = classLoader;
        return pf.getProxy(classLoader2);
    }

    protected Object getResource(LookupElement element, @Nullable String requestingBeanName) throws NoSuchBeanDefinitionException {
        String jndiName = null;
        if (StringUtils.hasLength(element.mappedName)) {
            jndiName = element.mappedName;
        } else if (this.alwaysUseJndiLookup) {
            jndiName = element.name;
        }
        if (jndiName != null) {
            if (this.jndiFactory == null) {
                throw new NoSuchBeanDefinitionException(element.lookupType, "No JNDI factory configured - specify the 'jndiFactory' property");
            }
            return this.jndiFactory.getBean(jndiName, element.lookupType);
        }
        if (this.resourceFactory == null) {
            throw new NoSuchBeanDefinitionException(element.lookupType, "No resource factory configured - specify the 'resourceFactory' property");
        }
        return this.autowireResource(this.resourceFactory, element, requestingBeanName);
    }

    protected Object autowireResource(BeanFactory factory, LookupElement element, @Nullable String requestingBeanName) throws NoSuchBeanDefinitionException {
        Object resource;
        Set<String> autowiredBeanNames;
        String name = element.name;
        if (factory instanceof AutowireCapableBeanFactory) {
            AutowireCapableBeanFactory autowireCapableBeanFactory = (AutowireCapableBeanFactory)factory;
            if (this.fallbackToDefaultTypeMatch && element.isDefaultName && !factory.containsBean(name)) {
                autowiredBeanNames = new LinkedHashSet<String>();
                resource = autowireCapableBeanFactory.resolveDependency(element.getDependencyDescriptor(), requestingBeanName, autowiredBeanNames, null);
                if (resource == null) {
                    throw new NoSuchBeanDefinitionException(element.getLookupType(), "No resolvable resource object");
                }
            } else {
                resource = autowireCapableBeanFactory.resolveBeanByName(name, element.getDependencyDescriptor());
                autowiredBeanNames = Collections.singleton(name);
            }
        } else {
            resource = factory.getBean(name, element.lookupType);
            autowiredBeanNames = Collections.singleton(name);
        }
        if (factory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)factory;
            for (String autowiredBeanName : autowiredBeanNames) {
                if (requestingBeanName == null || !configurableBeanFactory.containsBean(autowiredBeanName)) continue;
                configurableBeanFactory.registerDependentBean(autowiredBeanName, requestingBeanName);
            }
        }
        return resource;
    }

    @Nullable
    private static Class<? extends Annotation> loadAnnotationType(String name) {
        try {
            return ClassUtils.forName(name, CommonAnnotationBeanPostProcessor.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    static {
        if (jakartaResourceType != null) {
            resourceAnnotationTypes.add(jakartaResourceType);
        }
        if ((javaxResourceType = CommonAnnotationBeanPostProcessor.loadAnnotationType("javax.annotation.Resource")) != null) {
            resourceAnnotationTypes.add(javaxResourceType);
        }
        if ((ejbAnnotationType = CommonAnnotationBeanPostProcessor.loadAnnotationType("jakarta.ejb.EJB")) != null) {
            resourceAnnotationTypes.add(ejbAnnotationType);
        }
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private static final String REGISTERED_BEAN_PARAMETER = "registeredBean";
        private static final String INSTANCE_PARAMETER = "instance";
        private final Class<?> target;
        private final Collection<LookupElement> lookupElements;
        @Nullable
        private final AutowireCandidateResolver candidateResolver;

        AotContribution(Class<?> target, Collection<LookupElement> lookupElements, @Nullable AutowireCandidateResolver candidateResolver) {
            this.target = target;
            this.lookupElements = lookupElements;
            this.candidateResolver = candidateResolver;
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            GeneratedClass generatedClass = generationContext.getGeneratedClasses().addForFeatureComponent("ResourceAutowiring", this.target, type -> {
                type.addJavadoc("Resource autowiring for {@link $T}.", this.target);
                type.addModifiers(javax.lang.model.element.Modifier.PUBLIC);
            });
            GeneratedMethod generateMethod = generatedClass.getMethods().add("apply", method -> {
                method.addJavadoc("Apply resource autowiring.", new Object[0]);
                method.addModifiers(javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC);
                method.addParameter((Type)((Object)RegisteredBean.class), REGISTERED_BEAN_PARAMETER, new javax.lang.model.element.Modifier[0]);
                method.addParameter(this.target, INSTANCE_PARAMETER, new javax.lang.model.element.Modifier[0]);
                method.returns(this.target);
                method.addCode(this.generateMethodCode(generatedClass.getName(), generationContext.getRuntimeHints()));
            });
            beanRegistrationCode.addInstancePostProcessor(generateMethod.toMethodReference());
            this.registerHints(generationContext.getRuntimeHints());
        }

        private CodeBlock generateMethodCode(ClassName targetClassName, RuntimeHints hints) {
            CodeBlock.Builder code = CodeBlock.builder();
            for (LookupElement lookupElement : this.lookupElements) {
                code.addStatement(this.generateMethodStatementForElement(targetClassName, lookupElement, hints));
            }
            code.addStatement("return $L", INSTANCE_PARAMETER);
            return code.build();
        }

        private CodeBlock generateMethodStatementForElement(ClassName targetClassName, LookupElement lookupElement, RuntimeHints hints) {
            Member member = lookupElement.getMember();
            if (member instanceof Field) {
                Field field2 = (Field)member;
                return this.generateMethodStatementForField(targetClassName, field2, lookupElement, hints);
            }
            if (member instanceof Method) {
                Method method = (Method)member;
                return this.generateMethodStatementForMethod(targetClassName, method, lookupElement, hints);
            }
            throw new IllegalStateException("Unsupported member type " + member.getClass().getName());
        }

        private CodeBlock generateMethodStatementForField(ClassName targetClassName, Field field2, LookupElement lookupElement, RuntimeHints hints) {
            hints.reflection().registerField(field2);
            CodeBlock resolver = this.generateFieldResolverCode(field2, lookupElement);
            AccessControl accessControl = AccessControl.forMember(field2);
            if (!accessControl.isAccessibleFrom(targetClassName)) {
                return CodeBlock.of("$L.resolveAndSet($L, $L)", resolver, REGISTERED_BEAN_PARAMETER, INSTANCE_PARAMETER);
            }
            return CodeBlock.of("$L.$L = $L.resolve($L)", INSTANCE_PARAMETER, field2.getName(), resolver, REGISTERED_BEAN_PARAMETER);
        }

        private CodeBlock generateFieldResolverCode(Field field2, LookupElement lookupElement) {
            if (lookupElement.isDefaultName) {
                return CodeBlock.of("$T.$L($S)", ResourceElementResolver.class, "forField", field2.getName());
            }
            return CodeBlock.of("$T.$L($S, $S)", ResourceElementResolver.class, "forField", field2.getName(), lookupElement.getName());
        }

        private CodeBlock generateMethodStatementForMethod(ClassName targetClassName, Method method, LookupElement lookupElement, RuntimeHints hints) {
            CodeBlock resolver = this.generateMethodResolverCode(method, lookupElement);
            AccessControl accessControl = AccessControl.forMember(method);
            if (!accessControl.isAccessibleFrom(targetClassName)) {
                hints.reflection().registerMethod(method, ExecutableMode.INVOKE);
                return CodeBlock.of("$L.resolveAndSet($L, $L)", resolver, REGISTERED_BEAN_PARAMETER, INSTANCE_PARAMETER);
            }
            hints.reflection().registerMethod(method, ExecutableMode.INTROSPECT);
            return CodeBlock.of("$L.$L($L.resolve($L))", INSTANCE_PARAMETER, method.getName(), resolver, REGISTERED_BEAN_PARAMETER);
        }

        private CodeBlock generateMethodResolverCode(Method method, LookupElement lookupElement) {
            if (lookupElement.isDefaultName) {
                return CodeBlock.of("$T.$L($S, $T.class)", ResourceElementResolver.class, "forMethod", method.getName(), lookupElement.getLookupType());
            }
            return CodeBlock.of("$T.$L($S, $T.class, $S)", ResourceElementResolver.class, "forMethod", method.getName(), lookupElement.getLookupType(), lookupElement.getName());
        }

        private void registerHints(RuntimeHints runtimeHints) {
            this.lookupElements.forEach(lookupElement -> this.registerProxyIfNecessary(runtimeHints, lookupElement.getDependencyDescriptor()));
        }

        private void registerProxyIfNecessary(RuntimeHints runtimeHints, DependencyDescriptor dependencyDescriptor) {
            Class<?> proxyClass;
            if (this.candidateResolver != null && (proxyClass = this.candidateResolver.getLazyResolutionProxyClass(dependencyDescriptor, null)) != null) {
                ClassHintUtils.registerProxyIfNecessary(proxyClass, runtimeHints);
            }
        }
    }

    protected static abstract class LookupElement
    extends InjectionMetadata.InjectedElement {
        protected String name = "";
        protected boolean isDefaultName = false;
        protected Class<?> lookupType = Object.class;
        @Nullable
        protected String mappedName;

        public LookupElement(Member member, @Nullable PropertyDescriptor pd) {
            super(member, pd);
        }

        public final String getName() {
            return this.name;
        }

        public final Class<?> getLookupType() {
            return this.lookupType;
        }

        public final DependencyDescriptor getDependencyDescriptor() {
            if (this.isField) {
                return new ResourceElementResolver.LookupDependencyDescriptor((Field)this.member, this.lookupType, this.isLazyLookup());
            }
            return new ResourceElementResolver.LookupDependencyDescriptor((Method)this.member, this.lookupType, this.isLazyLookup());
        }

        boolean isLazyLookup() {
            return false;
        }
    }

    private class EjbRefElement
    extends LookupElement {
        private final String beanName;

        public EjbRefElement(Member member, @Nullable AnnotatedElement ae, PropertyDescriptor pd) {
            Class<?> resourceType;
            super(member, pd);
            EJB resource = ae.getAnnotation(EJB.class);
            String resourceBeanName = resource.beanName();
            String resourceName = resource.name();
            boolean bl = this.isDefaultName = !StringUtils.hasLength(resourceName);
            if (this.isDefaultName) {
                resourceName = this.member.getName();
                if (this.member instanceof Method && resourceName.startsWith("set") && resourceName.length() > 3) {
                    resourceName = StringUtils.uncapitalizeAsProperty(resourceName.substring(3));
                }
            }
            if (Object.class != (resourceType = resource.beanInterface())) {
                this.checkResourceType(resourceType);
            } else {
                resourceType = this.getResourceType();
            }
            this.beanName = resourceBeanName;
            this.name = resourceName;
            this.lookupType = resourceType;
            this.mappedName = resource.mappedName();
        }

        @Override
        protected Object getResourceToInject(Object target, @Nullable String requestingBeanName) {
            if (StringUtils.hasLength(this.beanName)) {
                if (CommonAnnotationBeanPostProcessor.this.beanFactory != null && CommonAnnotationBeanPostProcessor.this.beanFactory.containsBean(this.beanName)) {
                    BeanFactory beanFactory;
                    Object bean2 = CommonAnnotationBeanPostProcessor.this.beanFactory.getBean(this.beanName, this.lookupType);
                    if (requestingBeanName != null && (beanFactory = CommonAnnotationBeanPostProcessor.this.beanFactory) instanceof ConfigurableBeanFactory) {
                        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
                        configurableBeanFactory.registerDependentBean(this.beanName, requestingBeanName);
                    }
                    return bean2;
                }
                if (this.isDefaultName && !StringUtils.hasLength(this.mappedName)) {
                    throw new NoSuchBeanDefinitionException(this.beanName, "Cannot resolve 'beanName' in local BeanFactory. Consider specifying a general 'name' value instead.");
                }
            }
            return CommonAnnotationBeanPostProcessor.this.getResource(this, requestingBeanName);
        }
    }

    private class ResourceElement
    extends LookupElement {
        private final boolean lazyLookup;

        public ResourceElement(Member member, @Nullable AnnotatedElement ae, PropertyDescriptor pd) {
            super(member, pd);
            Resource resource = ae.getAnnotation(Resource.class);
            String resourceName = resource.name();
            Class<?> resourceType = resource.type();
            boolean bl = this.isDefaultName = !StringUtils.hasLength(resourceName);
            if (this.isDefaultName) {
                resourceName = this.member.getName();
                if (this.member instanceof Method && resourceName.startsWith("set") && resourceName.length() > 3) {
                    resourceName = StringUtils.uncapitalizeAsProperty(resourceName.substring(3));
                }
            } else if (CommonAnnotationBeanPostProcessor.this.embeddedValueResolver != null) {
                resourceName = CommonAnnotationBeanPostProcessor.this.embeddedValueResolver.resolveStringValue(resourceName);
            }
            if (Object.class != resourceType) {
                this.checkResourceType(resourceType);
            } else {
                resourceType = this.getResourceType();
            }
            this.name = resourceName != null ? resourceName : "";
            this.lookupType = resourceType;
            String lookupValue = resource.lookup();
            this.mappedName = StringUtils.hasLength(lookupValue) ? lookupValue : resource.mappedName();
            Lazy lazy = ae.getAnnotation(Lazy.class);
            this.lazyLookup = lazy != null && lazy.value();
        }

        @Override
        protected Object getResourceToInject(Object target, @Nullable String requestingBeanName) {
            return this.lazyLookup ? CommonAnnotationBeanPostProcessor.this.buildLazyResourceProxy(this, requestingBeanName) : CommonAnnotationBeanPostProcessor.this.getResource(this, requestingBeanName);
        }

        @Override
        boolean isLazyLookup() {
            return this.lazyLookup;
        }
    }

    private class LegacyResourceElement
    extends LookupElement {
        private final boolean lazyLookup;

        public LegacyResourceElement(Member member, @Nullable AnnotatedElement ae, PropertyDescriptor pd) {
            super(member, pd);
            javax.annotation.Resource resource = ae.getAnnotation(javax.annotation.Resource.class);
            String resourceName = resource.name();
            Class<?> resourceType = resource.type();
            boolean bl = this.isDefaultName = !StringUtils.hasLength(resourceName);
            if (this.isDefaultName) {
                resourceName = this.member.getName();
                if (this.member instanceof Method && resourceName.startsWith("set") && resourceName.length() > 3) {
                    resourceName = StringUtils.uncapitalizeAsProperty(resourceName.substring(3));
                }
            } else if (CommonAnnotationBeanPostProcessor.this.embeddedValueResolver != null) {
                resourceName = CommonAnnotationBeanPostProcessor.this.embeddedValueResolver.resolveStringValue(resourceName);
            }
            if (Object.class != resourceType) {
                this.checkResourceType(resourceType);
            } else {
                resourceType = this.getResourceType();
            }
            this.name = resourceName != null ? resourceName : "";
            this.lookupType = resourceType;
            String lookupValue = resource.lookup();
            this.mappedName = StringUtils.hasLength(lookupValue) ? lookupValue : resource.mappedName();
            Lazy lazy = ae.getAnnotation(Lazy.class);
            this.lazyLookup = lazy != null && lazy.value();
        }

        @Override
        protected Object getResourceToInject(Object target, @Nullable String requestingBeanName) {
            return this.lazyLookup ? CommonAnnotationBeanPostProcessor.this.buildLazyResourceProxy(this, requestingBeanName) : CommonAnnotationBeanPostProcessor.this.getResource(this, requestingBeanName);
        }

        @Override
        boolean isLazyLookup() {
            return this.lazyLookup;
        }
    }
}

