/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class SimpleErrors
implements Errors,
Serializable {
    private final Object target;
    private final String objectName;
    private final List<ObjectError> globalErrors = new ArrayList<ObjectError>();
    private final List<FieldError> fieldErrors = new ArrayList<FieldError>();

    public SimpleErrors(Object target) {
        Assert.notNull(target, "Target must not be null");
        this.target = target;
        this.objectName = this.target.getClass().getSimpleName();
    }

    public SimpleErrors(Object target, String objectName) {
        Assert.notNull(target, "Target must not be null");
        this.target = target;
        this.objectName = objectName;
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public void reject(String errorCode, @Nullable Object[] errorArgs, @Nullable String defaultMessage) {
        this.globalErrors.add(new ObjectError(this.getObjectName(), new String[]{errorCode}, errorArgs, defaultMessage));
    }

    @Override
    public void rejectValue(@Nullable String field2, String errorCode, @Nullable Object[] errorArgs, @Nullable String defaultMessage) {
        if (!StringUtils.hasLength(field2)) {
            this.reject(errorCode, errorArgs, defaultMessage);
            return;
        }
        Object newVal = this.getFieldValue(field2);
        this.fieldErrors.add(new FieldError(this.getObjectName(), field2, newVal, false, new String[]{errorCode}, errorArgs, defaultMessage));
    }

    @Override
    public void addAllErrors(Errors errors) {
        this.globalErrors.addAll(errors.getGlobalErrors());
        this.fieldErrors.addAll(errors.getFieldErrors());
    }

    @Override
    public List<ObjectError> getGlobalErrors() {
        return this.globalErrors;
    }

    @Override
    public List<FieldError> getFieldErrors() {
        return this.fieldErrors;
    }

    @Override
    @Nullable
    public Object getFieldValue(String field2) {
        FieldError fieldError = this.getFieldError(field2);
        if (fieldError != null) {
            return fieldError.getRejectedValue();
        }
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(this.target.getClass(), field2);
        if (pd != null && pd.getReadMethod() != null) {
            ReflectionUtils.makeAccessible(pd.getReadMethod());
            return ReflectionUtils.invokeMethod(pd.getReadMethod(), this.target);
        }
        Field rawField = ReflectionUtils.findField(this.target.getClass(), field2);
        if (rawField != null) {
            ReflectionUtils.makeAccessible(rawField);
            return ReflectionUtils.getField(rawField, this.target);
        }
        throw new IllegalArgumentException("Cannot retrieve value for field '" + field2 + "' - neither a getter method nor a raw field found");
    }

    @Override
    @Nullable
    public Class<?> getFieldType(String field2) {
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(this.target.getClass(), field2);
        if (pd != null) {
            return pd.getPropertyType();
        }
        Field rawField = ReflectionUtils.findField(this.target.getClass(), field2);
        if (rawField != null) {
            return rawField.getType();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof SimpleErrors)) return false;
        SimpleErrors that = (SimpleErrors)other;
        if (!ObjectUtils.nullSafeEquals(this.target, that.target)) return false;
        if (!this.globalErrors.equals(that.globalErrors)) return false;
        if (!this.fieldErrors.equals(that.fieldErrors)) return false;
        return true;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ObjectError objectError : this.globalErrors) {
            sb.append('\n').append(objectError);
        }
        for (ObjectError objectError : this.fieldErrors) {
            sb.append('\n').append(objectError);
        }
        return sb.toString();
    }
}

