/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.processing.EngineProcessors;
import io.camunda.zeebe.engine.processing.deployment.DeploymentResponder;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorListener;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.engine.EngineStateMonitor;
import io.camunda.zeebe.process.test.engine.GrpcResponseWriter;
import io.camunda.zeebe.process.test.engine.GrpcToLogStreamGateway;
import io.camunda.zeebe.process.test.engine.InMemoryEngine;
import io.camunda.zeebe.process.test.engine.InMemoryLogStorage;
import io.camunda.zeebe.process.test.engine.RecordStreamSourceImpl;
import io.camunda.zeebe.process.test.engine.SinglePartitionDeploymentDistributor;
import io.camunda.zeebe.process.test.engine.SinglePartitionDeploymentResponder;
import io.camunda.zeebe.process.test.engine.SubscriptionCommandSenderFactory;
import io.camunda.zeebe.process.test.engine.db.InMemoryDbFactory;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.camunda.zeebe.util.sched.clock.ControlledActorClock;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.util.concurrent.CompletableFuture;

public class EngineFactory {
    public static ZeebeTestEngine create() {
        return EngineFactory.create(26500);
    }

    public static ZeebeTestEngine create(int port) {
        boolean partitionId = true;
        boolean partitionCount = true;
        ControlledActorClock clock = EngineFactory.createActorClock();
        ActorScheduler scheduler = EngineFactory.createAndStartActorScheduler((ActorClock)clock);
        InMemoryLogStorage logStorage = new InMemoryLogStorage();
        LogStream logStream = EngineFactory.createLogStream(logStorage, (ActorSchedulingService)scheduler, 1);
        SubscriptionCommandSenderFactory subscriptionCommandSenderFactory = new SubscriptionCommandSenderFactory((LogStreamRecordWriter)logStream.newLogStreamRecordWriter().join(), 1);
        GrpcToLogStreamGateway gateway = new GrpcToLogStreamGateway((LogStreamRecordWriter)logStream.newLogStreamRecordWriter().join(), 1, 1, port);
        Server grpcServer = ServerBuilder.forPort((int)port).addService((BindableService)gateway).build();
        GrpcResponseWriter grpcResponseWriter = new GrpcResponseWriter(gateway);
        ZeebeDb<ZbColumnFamilies> zeebeDb = EngineFactory.createDatabase();
        EngineStateMonitor engineStateMonitor = new EngineStateMonitor(logStorage, (LogStreamReader)logStream.newLogStreamReader().join());
        StreamProcessor streamProcessor = EngineFactory.createStreamProcessor(logStream, zeebeDb, (ActorSchedulingService)scheduler, grpcResponseWriter, engineStateMonitor, 1, subscriptionCommandSenderFactory);
        LogStreamReader reader = (LogStreamReader)logStream.newLogStreamReader().join();
        RecordStreamSourceImpl recordStream = new RecordStreamSourceImpl(reader, 1);
        return new InMemoryEngine(grpcServer, streamProcessor, gateway, zeebeDb, logStream, scheduler, recordStream, clock, engineStateMonitor);
    }

    private static ControlledActorClock createActorClock() {
        return new ControlledActorClock();
    }

    private static ActorScheduler createAndStartActorScheduler(ActorClock clock) {
        ActorScheduler scheduler = ActorScheduler.newActorScheduler().setActorClock(clock).build();
        scheduler.start();
        return scheduler;
    }

    private static LogStream createLogStream(LogStorage logStorage, ActorSchedulingService scheduler, int partitionId) {
        LogStreamBuilder builder = LogStream.builder().withPartitionId(partitionId).withLogStorage(logStorage).withActorSchedulingService(scheduler);
        CompletableFuture theFuture = new CompletableFuture();
        scheduler.submitActor(Actor.wrap(control -> builder.buildAsync().onComplete((logStream, failure) -> {
            if (failure != null) {
                theFuture.completeExceptionally((Throwable)failure);
            } else {
                theFuture.complete(logStream);
            }
        })));
        return (LogStream)theFuture.join();
    }

    private static ZeebeDb<ZbColumnFamilies> createDatabase() {
        InMemoryDbFactory factory = new InMemoryDbFactory();
        return factory.createDb();
    }

    private static StreamProcessor createStreamProcessor(LogStream logStream, ZeebeDb<ZbColumnFamilies> database, ActorSchedulingService scheduler, GrpcResponseWriter grpcResponseWriter, EngineStateMonitor engineStateMonitor, int partitionCount, SubscriptionCommandSenderFactory subscriptionCommandSenderFactory) {
        return StreamProcessor.builder().logStream(logStream).zeebeDb(database).eventApplierFactory(EventAppliers::new).commandResponseWriter((CommandResponseWriter)grpcResponseWriter).streamProcessorFactory(context -> EngineProcessors.createEngineProcessors((ProcessingContext)context.listener((StreamProcessorListener)engineStateMonitor), (int)partitionCount, (SubscriptionCommandSender)subscriptionCommandSenderFactory.createSender(), (DeploymentDistributor)new SinglePartitionDeploymentDistributor(), (DeploymentResponder)new SinglePartitionDeploymentResponder(), jobType -> {})).actorSchedulingService(scheduler).build();
    }
}

