/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import com.google.protobuf.GeneratedMessageV3;
import com.google.rpc.Status;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.process.test.engine.GrpcToLogStreamGateway;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceResultRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

class GrpcResponseWriter
implements CommandResponseWriter {
    private static long key = -1L;
    private static final DirectBuffer valueBufferView = new UnsafeBuffer();
    private static Intent intent = Intent.UNKNOWN;
    final GrpcToLogStreamGateway gateway;
    private int partitionId = -1;
    private RecordType recordType = RecordType.NULL_VAL;
    private ValueType valueType = ValueType.NULL_VAL;
    private RejectionType rejectionType = RejectionType.NULL_VAL;
    private String rejectionReason = "";
    private final MutableDirectBuffer valueBuffer = new ExpandableArrayBuffer();

    public GrpcResponseWriter(GrpcToLogStreamGateway gateway) {
        this.gateway = gateway;
    }

    public CommandResponseWriter partitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public CommandResponseWriter key(long key) {
        GrpcResponseWriter.key = key;
        return this;
    }

    public CommandResponseWriter intent(Intent intent) {
        GrpcResponseWriter.intent = intent;
        return this;
    }

    public CommandResponseWriter recordType(RecordType type) {
        this.recordType = type;
        return this;
    }

    public CommandResponseWriter valueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public CommandResponseWriter rejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
        return this;
    }

    public CommandResponseWriter rejectionReason(DirectBuffer rejectionReason) {
        this.rejectionReason = BufferUtil.bufferAsString((DirectBuffer)rejectionReason);
        return this;
    }

    public CommandResponseWriter valueWriter(BufferWriter value) {
        value.write(this.valueBuffer, 0);
        valueBufferView.wrap((DirectBuffer)this.valueBuffer, 0, value.getLength());
        return this;
    }

    public boolean tryWriteResponse(int requestStreamId, long requestId) {
        if (this.rejectionType != RejectionType.NULL_VAL) {
            Status rejectionResponse = this.createRejectionResponse();
            this.gateway.errorCallback(requestId, rejectionResponse);
            return true;
        }
        try {
            this.gateway.responseCallback(requestId);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated(since="8.0.0")
    static GatewayOuterClass.DeployProcessResponse createDeployResponse() {
        DeploymentRecord deployment = new DeploymentRecord();
        deployment.wrap(valueBufferView);
        return GatewayOuterClass.DeployProcessResponse.newBuilder().setKey(key).addAllProcesses((Iterable)deployment.getProcessesMetadata().stream().map(metadata -> GatewayOuterClass.ProcessMetadata.newBuilder().setProcessDefinitionKey(metadata.getProcessDefinitionKey()).setBpmnProcessId(metadata.getBpmnProcessId()).setVersion(metadata.getVersion()).setResourceName(metadata.getResourceName()).build()).collect(Collectors.toList())).build();
    }

    static GeneratedMessageV3 createDeployResourceResponse() {
        DeploymentRecord deployment = new DeploymentRecord();
        deployment.wrap(valueBufferView);
        GatewayOuterClass.DeployResourceResponse.Builder builder = GatewayOuterClass.DeployResourceResponse.newBuilder().setKey(key);
        deployment.getProcessesMetadata().stream().map(metadata -> GatewayOuterClass.ProcessMetadata.newBuilder().setBpmnProcessId(metadata.getBpmnProcessId()).setVersion(metadata.getVersion()).setProcessDefinitionKey(metadata.getProcessDefinitionKey()).setResourceName(metadata.getResourceName()).build()).forEach(metadata -> builder.addDeploymentsBuilder().setProcess(metadata));
        deployment.decisionsMetadata().stream().map(metadata -> GatewayOuterClass.DecisionMetadata.newBuilder().setDmnDecisionId(metadata.getDecisionId()).setDmnDecisionName(metadata.getDecisionName()).setVersion(metadata.getVersion()).setDecisionKey(metadata.getDecisionKey()).setDmnDecisionRequirementsId(metadata.getDecisionRequirementsId()).setDecisionRequirementsKey(metadata.getDecisionRequirementsKey()).build()).forEach(metadata -> builder.addDeploymentsBuilder().setDecision(metadata));
        deployment.decisionRequirementsMetadata().stream().map(metadata -> GatewayOuterClass.DecisionRequirementsMetadata.newBuilder().setDmnDecisionRequirementsId(metadata.getDecisionRequirementsId()).setDmnDecisionRequirementsName(metadata.getDecisionRequirementsName()).setVersion(metadata.getDecisionRequirementsVersion()).setDecisionRequirementsKey(metadata.getDecisionRequirementsKey()).setResourceName(metadata.getResourceName()).build()).forEach(metadata -> builder.addDeploymentsBuilder().setDecisionRequirements(metadata));
        return builder.build();
    }

    static GeneratedMessageV3 createProcessInstanceResponse() {
        ProcessInstanceCreationRecord processInstance = new ProcessInstanceCreationRecord();
        processInstance.wrap(valueBufferView);
        return GatewayOuterClass.CreateProcessInstanceResponse.newBuilder().setProcessInstanceKey(processInstance.getProcessInstanceKey()).setProcessDefinitionKey(processInstance.getProcessDefinitionKey()).setBpmnProcessId(processInstance.getBpmnProcessId()).setVersion(processInstance.getVersion()).build();
    }

    static GeneratedMessageV3 createProcessInstanceWithResultResponse() {
        ProcessInstanceResultRecord processInstanceResult = new ProcessInstanceResultRecord();
        processInstanceResult.wrap(valueBufferView);
        return GatewayOuterClass.CreateProcessInstanceWithResultResponse.newBuilder().setProcessInstanceKey(processInstanceResult.getProcessInstanceKey()).setProcessDefinitionKey(processInstanceResult.getProcessDefinitionKey()).setBpmnProcessId(processInstanceResult.getBpmnProcessId()).setVersion(processInstanceResult.getVersion()).setVariables(MsgPackConverter.convertToJson((DirectBuffer)processInstanceResult.getVariablesBuffer())).build();
    }

    static GeneratedMessageV3 createCancelInstanceResponse() {
        return GatewayOuterClass.CancelProcessInstanceResponse.newBuilder().build();
    }

    static GeneratedMessageV3 createResolveIncidentResponse() {
        IncidentRecord incident = new IncidentRecord();
        incident.wrap(valueBufferView);
        return GatewayOuterClass.ResolveIncidentResponse.newBuilder().build();
    }

    static GeneratedMessageV3 createSetVariablesResponse() {
        VariableDocumentRecord variableDocumentRecord = new VariableDocumentRecord();
        variableDocumentRecord.wrap(valueBufferView);
        return GatewayOuterClass.SetVariablesResponse.newBuilder().setKey(key).build();
    }

    static GeneratedMessageV3 createMessageResponse() {
        return GatewayOuterClass.PublishMessageResponse.newBuilder().setKey(key).build();
    }

    static GeneratedMessageV3 createJobBatchResponse() {
        JobBatchRecord jobBatch = new JobBatchRecord();
        jobBatch.wrap(valueBufferView);
        HashMap<Long, JobRecord> jobsWithKeys = new HashMap<Long, JobRecord>();
        for (int index = 0; index < jobBatch.getJobKeys().size(); ++index) {
            Long key = (Long)jobBatch.getJobKeys().get(index);
            JobRecord value = (JobRecord)jobBatch.getJobs().get(index);
            jobsWithKeys.put(key, value);
        }
        return GatewayOuterClass.ActivateJobsResponse.newBuilder().addAllJobs((Iterable)jobsWithKeys.entrySet().stream().map(entry -> {
            JobRecord job = (JobRecord)entry.getValue();
            return GatewayOuterClass.ActivatedJob.newBuilder().setKey(((Long)entry.getKey()).longValue()).setType(job.getType()).setRetries(job.getRetries()).setWorker(job.getWorker()).setDeadline(job.getDeadline()).setProcessDefinitionKey(job.getProcessDefinitionKey()).setBpmnProcessId(job.getBpmnProcessId()).setProcessDefinitionVersion(job.getProcessDefinitionVersion()).setProcessInstanceKey(job.getProcessInstanceKey()).setElementId(job.getElementId()).setElementInstanceKey(job.getElementInstanceKey()).setCustomHeaders(MsgPackConverter.convertToJson((DirectBuffer)job.getCustomHeadersBuffer())).setVariables(MsgPackConverter.convertToJson((DirectBuffer)job.getVariablesBuffer())).build();
        }).collect(Collectors.toList())).build();
    }

    static GeneratedMessageV3 createCompleteJobResponse() {
        return GatewayOuterClass.CompleteJobResponse.newBuilder().build();
    }

    static GeneratedMessageV3 createFailJobResponse() {
        return GatewayOuterClass.FailJobResponse.newBuilder().build();
    }

    static GeneratedMessageV3 createJobThrowErrorResponse() {
        return GatewayOuterClass.ThrowErrorResponse.newBuilder().build();
    }

    static GeneratedMessageV3 createJobUpdateRetriesResponse() {
        return GatewayOuterClass.UpdateJobRetriesResponse.newBuilder().build();
    }

    static GeneratedMessageV3 createJobResponse() {
        return switch ((JobIntent)intent) {
            case JobIntent.COMPLETED -> GrpcResponseWriter.createCompleteJobResponse();
            case JobIntent.FAILED -> GrpcResponseWriter.createFailJobResponse();
            case JobIntent.ERROR_THROWN -> GrpcResponseWriter.createJobThrowErrorResponse();
            case JobIntent.RETRIES_UPDATED -> GrpcResponseWriter.createJobUpdateRetriesResponse();
            default -> throw new UnsupportedOperationException(String.format("Job command '%s' is not supported", intent));
        };
    }

    private Status createRejectionResponse() {
        int statusCode = switch (this.rejectionType) {
            case RejectionType.INVALID_ARGUMENT -> 3;
            case RejectionType.NOT_FOUND -> 5;
            case RejectionType.ALREADY_EXISTS -> 6;
            case RejectionType.INVALID_STATE -> 9;
            case RejectionType.PROCESSING_ERROR -> 13;
            default -> 2;
        };
        return Status.newBuilder().setMessage(String.format("Command '%s' rejected with code '%s': %s", intent, this.rejectionType, this.rejectionReason)).setCode(statusCode).build();
    }

    @FunctionalInterface
    public static interface GrpcResponseMapper<GrpcResponseType extends GeneratedMessageV3> {
        public GrpcResponseType apply();
    }
}

