/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import com.google.protobuf.GeneratedMessageV3;
import com.google.rpc.Status;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.process.test.engine.GrpcResponseWriter;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.camunda.zeebe.util.VersionUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.grpc.protobuf.StatusProto;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.agrona.DirectBuffer;

class GrpcToLogStreamGateway
extends GatewayGrpc.GatewayImplBase
implements AutoCloseable {
    private final LogStreamRecordWriter writer;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Map<Long, ResponseSender> responseSenderMap = new HashMap<Long, ResponseSender>();
    private final RecordMetadata recordMetadata = new RecordMetadata();
    private final AtomicLong requestIdGenerator = new AtomicLong();
    private final int partitionId;
    private final int partitionCount;
    private final int port;

    public GrpcToLogStreamGateway(LogStreamRecordWriter writer, int partitionId, int partitionCount, int port) {
        this.writer = writer;
        this.partitionId = partitionId;
        this.partitionCount = partitionCount;
        this.port = port;
    }

    private void writeCommandWithKey(Long key, RecordMetadata metadata, BufferWriter bufferWriter) {
        this.writer.reset();
        this.writer.key(key.longValue()).metadataWriter((BufferWriter)metadata).valueWriter(bufferWriter).tryWrite();
    }

    private void writeCommandWithoutKey(RecordMetadata metadata, BufferWriter bufferWriter) {
        this.writer.reset();
        this.writer.keyNull().metadataWriter((BufferWriter)metadata).valueWriter(bufferWriter).tryWrite();
    }

    public void activateJobs(GatewayOuterClass.ActivateJobsRequest request, StreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createJobBatchResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB_BATCH).intent((Intent)JobBatchIntent.ACTIVATE);
            JobBatchRecord jobBatchRecord = new JobBatchRecord();
            jobBatchRecord.setType(request.getType());
            jobBatchRecord.setWorker(request.getWorker());
            jobBatchRecord.setTimeout(request.getTimeout());
            jobBatchRecord.setMaxJobsToActivate(request.getMaxJobsToActivate());
            this.writeCommandWithoutKey(this.recordMetadata, (BufferWriter)jobBatchRecord);
        });
    }

    public void cancelProcessInstance(GatewayOuterClass.CancelProcessInstanceRequest request, StreamObserver<GatewayOuterClass.CancelProcessInstanceResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createCancelInstanceResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.PROCESS_INSTANCE).intent((Intent)ProcessInstanceIntent.CANCEL);
            ProcessInstanceRecord processInstanceRecord = new ProcessInstanceRecord();
            processInstanceRecord.setProcessInstanceKey(request.getProcessInstanceKey());
            this.writeCommandWithKey(request.getProcessInstanceKey(), this.recordMetadata, (BufferWriter)processInstanceRecord);
        });
    }

    public void completeJob(GatewayOuterClass.CompleteJobRequest request, StreamObserver<GatewayOuterClass.CompleteJobResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createCompleteJobResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB).intent((Intent)JobIntent.COMPLETE);
            JobRecord jobRecord = new JobRecord();
            String variables = request.getVariables();
            if (!variables.isEmpty()) {
                jobRecord.setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)variables)));
            }
            this.writeCommandWithKey(request.getJobKey(), this.recordMetadata, (BufferWriter)jobRecord);
        });
    }

    public void createProcessInstance(GatewayOuterClass.CreateProcessInstanceRequest request, StreamObserver<GatewayOuterClass.CreateProcessInstanceResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createProcessInstanceResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.PROCESS_INSTANCE_CREATION).intent((Intent)ProcessInstanceCreationIntent.CREATE);
            ProcessInstanceCreationRecord processInstanceCreationRecord = this.createProcessInstanceCreationRecord(request);
            this.writeCommandWithoutKey(this.recordMetadata, (BufferWriter)processInstanceCreationRecord);
        });
    }

    public void createProcessInstanceWithResult(GatewayOuterClass.CreateProcessInstanceWithResultRequest request, StreamObserver<GatewayOuterClass.CreateProcessInstanceWithResultResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createProcessInstanceWithResultResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.PROCESS_INSTANCE_CREATION).intent((Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT);
            ProcessInstanceCreationRecord processInstanceCreationRecord = this.createProcessInstanceCreationRecord(request.getRequest());
            processInstanceCreationRecord.setFetchVariables((List)request.getFetchVariablesList());
            this.writeCommandWithoutKey(this.recordMetadata, (BufferWriter)processInstanceCreationRecord);
        });
    }

    public void deployProcess(GatewayOuterClass.DeployProcessRequest request, StreamObserver<GatewayOuterClass.DeployProcessResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createDeployResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.DEPLOYMENT).intent((Intent)DeploymentIntent.CREATE);
            DeploymentRecord deploymentRecord = new DeploymentRecord();
            ValueArray resources = deploymentRecord.resources();
            request.getProcessesList().forEach(processRequestObject -> ((DeploymentResource)resources.add()).setResourceName(processRequestObject.getName()).setResource(processRequestObject.getDefinition().toByteArray()));
            this.writeCommandWithoutKey(this.recordMetadata, (BufferWriter)deploymentRecord);
        });
    }

    public void deployResource(GatewayOuterClass.DeployResourceRequest request, StreamObserver<GatewayOuterClass.DeployResourceResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createDeployResourceResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.DEPLOYMENT).intent((Intent)DeploymentIntent.CREATE);
            DeploymentRecord deploymentRecord = new DeploymentRecord();
            ValueArray resources = deploymentRecord.resources();
            request.getResourcesList().forEach(resource -> ((DeploymentResource)resources.add()).setResourceName(resource.getName()).setResource(resource.getContent().toByteArray()));
            this.writeCommandWithoutKey(this.recordMetadata, (BufferWriter)deploymentRecord);
        });
    }

    public void failJob(GatewayOuterClass.FailJobRequest request, StreamObserver<GatewayOuterClass.FailJobResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createFailJobResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB).intent((Intent)JobIntent.FAIL);
            JobRecord jobRecord = new JobRecord();
            jobRecord.setRetries(request.getRetries());
            jobRecord.setErrorMessage(request.getErrorMessage());
            this.writeCommandWithKey(request.getJobKey(), this.recordMetadata, (BufferWriter)jobRecord);
        });
    }

    public void throwError(GatewayOuterClass.ThrowErrorRequest request, StreamObserver<GatewayOuterClass.ThrowErrorResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createJobThrowErrorResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB).intent((Intent)JobIntent.THROW_ERROR);
            JobRecord jobRecord = new JobRecord();
            jobRecord.setErrorCode(BufferUtil.wrapString((String)request.getErrorCode()));
            jobRecord.setErrorMessage(request.getErrorMessage());
            this.writeCommandWithKey(request.getJobKey(), this.recordMetadata, (BufferWriter)jobRecord);
        });
    }

    public void publishMessage(GatewayOuterClass.PublishMessageRequest request, StreamObserver<GatewayOuterClass.PublishMessageResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createMessageResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.MESSAGE).intent((Intent)MessageIntent.PUBLISH);
            MessageRecord messageRecord = new MessageRecord();
            messageRecord.setCorrelationKey(request.getCorrelationKey());
            messageRecord.setMessageId(request.getMessageId());
            messageRecord.setName(request.getName());
            messageRecord.setTimeToLive(request.getTimeToLive());
            String variables = request.getVariables();
            if (!variables.isEmpty()) {
                messageRecord.setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)variables)));
            }
            this.writeCommandWithoutKey(this.recordMetadata, (BufferWriter)messageRecord);
        });
    }

    public void resolveIncident(GatewayOuterClass.ResolveIncidentRequest request, StreamObserver<GatewayOuterClass.ResolveIncidentResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createResolveIncidentResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.INCIDENT).intent((Intent)IncidentIntent.RESOLVE);
            IncidentRecord incidentRecord = new IncidentRecord();
            this.writeCommandWithKey(request.getIncidentKey(), this.recordMetadata, (BufferWriter)incidentRecord);
        });
    }

    public void setVariables(GatewayOuterClass.SetVariablesRequest request, StreamObserver<GatewayOuterClass.SetVariablesResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createSetVariablesResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.VARIABLE_DOCUMENT).intent((Intent)VariableDocumentIntent.UPDATE);
            VariableDocumentRecord variableDocumentRecord = new VariableDocumentRecord();
            String variables = request.getVariables();
            if (!variables.isEmpty()) {
                variableDocumentRecord.setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)variables)));
            }
            variableDocumentRecord.setScopeKey(request.getElementInstanceKey());
            variableDocumentRecord.setUpdateSemantics(request.getLocal() ? VariableDocumentUpdateSemantic.LOCAL : VariableDocumentUpdateSemantic.PROPAGATE);
            this.writeCommandWithoutKey(this.recordMetadata, (BufferWriter)variableDocumentRecord);
        });
    }

    public void topology(GatewayOuterClass.TopologyRequest request, StreamObserver<GatewayOuterClass.TopologyResponse> responseObserver) {
        GatewayOuterClass.Partition partition = GatewayOuterClass.Partition.newBuilder().setHealth(GatewayOuterClass.Partition.PartitionBrokerHealth.HEALTHY).setRole(GatewayOuterClass.Partition.PartitionBrokerRole.LEADER).setPartitionId(this.partitionId).build();
        GatewayOuterClass.BrokerInfo brokerInfo = GatewayOuterClass.BrokerInfo.newBuilder().addPartitions(partition).setHost("0.0.0.0").setPort(this.port).setVersion(VersionUtil.getVersion()).build();
        GatewayOuterClass.TopologyResponse topologyResponse = GatewayOuterClass.TopologyResponse.newBuilder().addBrokers(brokerInfo).setClusterSize(1).setPartitionsCount(this.partitionCount).setReplicationFactor(1).setGatewayVersion(VersionUtil.getVersion()).build();
        responseObserver.onNext((Object)topologyResponse);
        responseObserver.onCompleted();
    }

    public void updateJobRetries(GatewayOuterClass.UpdateJobRetriesRequest request, StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse> responseObserver) {
        this.executor.submit(() -> {
            Long requestId = this.registerNewRequest(responseObserver, GrpcResponseWriter::createJobUpdateRetriesResponse);
            this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB).intent((Intent)JobIntent.UPDATE_RETRIES);
            JobRecord jobRecord = new JobRecord();
            jobRecord.setRetries(request.getRetries());
            this.writeCommandWithKey(request.getJobKey(), this.recordMetadata, (BufferWriter)jobRecord);
        });
    }

    @Override
    public void close() {
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private RecordMetadata prepareRecordMetadata() {
        return this.recordMetadata.reset().recordType(RecordType.COMMAND).requestStreamId(this.partitionId);
    }

    private <GrpcResponseType extends GeneratedMessageV3> Long registerNewRequest(StreamObserver<?> responseObserver, GrpcResponseWriter.GrpcResponseMapper<GrpcResponseType> responseMapper) {
        long currentRequestId = this.requestIdGenerator.incrementAndGet();
        this.responseSenderMap.put(currentRequestId, new ResponseSender(responseObserver, responseMapper));
        return currentRequestId;
    }

    private ProcessInstanceCreationRecord createProcessInstanceCreationRecord(GatewayOuterClass.CreateProcessInstanceRequest request) {
        ProcessInstanceCreationRecord processInstanceCreationRecord = new ProcessInstanceCreationRecord();
        processInstanceCreationRecord.setBpmnProcessId(request.getBpmnProcessId());
        processInstanceCreationRecord.setVersion(request.getVersion());
        processInstanceCreationRecord.setProcessDefinitionKey(request.getProcessDefinitionKey());
        String variables = request.getVariables();
        if (!variables.isEmpty()) {
            processInstanceCreationRecord.setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)variables)));
        }
        return processInstanceCreationRecord;
    }

    public void responseCallback(Long requestId) {
        this.executor.submit(() -> {
            ResponseSender responseSender = this.responseSenderMap.remove(requestId);
            responseSender.sendResponse();
        });
    }

    public void errorCallback(Long requestId, Status error) {
        this.executor.submit(() -> {
            ResponseSender responseSender = this.responseSenderMap.remove(requestId);
            responseSender.sendError(error);
        });
    }

    public String getAddress() {
        return "0.0.0.0:" + this.port;
    }

    private record ResponseSender(StreamObserver<?> responseObserver, GrpcResponseWriter.GrpcResponseMapper<? extends GeneratedMessageV3> responseMapper) {
        void sendResponse() {
            GeneratedMessageV3 response = this.responseMapper.apply();
            StreamObserver<?> streamObserver = this.responseObserver;
            streamObserver.onNext((Object)response);
            streamObserver.onCompleted();
        }

        void sendError(Status error) {
            StreamObserver<?> streamObserver = this.responseObserver;
            streamObserver.onError((Throwable)StatusProto.toStatusException((Status)error));
        }
    }
}

