/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine.db;

import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.impl.ZeebeDbConstants;
import io.camunda.zeebe.process.test.engine.db.Bytes;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

final class FullyQualifiedKey {
    private final Bytes keyBytes;

    FullyQualifiedKey(Enum columnFamily, DbKey dbKey) {
        ExpandableArrayBuffer keyBuffer = new ExpandableArrayBuffer();
        keyBuffer.putLong(0, (long)columnFamily.ordinal(), ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        dbKey.write((MutableDirectBuffer)keyBuffer, 8);
        this.keyBytes = Bytes.fromExpandableArrayBuffer(keyBuffer);
    }

    Bytes getKeyBytes() {
        return this.keyBytes;
    }

    static DirectBuffer wrapKey(byte[] rawKeyBytes) {
        UnsafeBuffer keyViewBuffer = new UnsafeBuffer(0L, 0);
        keyViewBuffer.wrap(rawKeyBytes, 8, rawKeyBytes.length - 8);
        return keyViewBuffer;
    }
}

