/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorListener;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.process.test.engine.InMemoryLogStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

final class EngineStateMonitor
implements LogStorage.CommitListener,
StreamProcessorListener {
    public static final int GRACE_PERIOD_MS = 50;
    private static final Timer TIMER = new Timer();
    private final List<Runnable> idleCallbacks = new ArrayList<Runnable>();
    private final List<Runnable> processingCallbacks = new ArrayList<Runnable>();
    private final LogStreamReader reader;
    private volatile long lastEventPosition = -1L;
    private volatile long lastProcessedPosition = -1L;
    private volatile TimerTask idleStateNotifier = this.createIdleStateNotifier();

    EngineStateMonitor(InMemoryLogStorage logStorage, LogStreamReader logStreamReader) {
        logStorage.addCommitListener(this);
        this.reader = logStreamReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnIdleCallback(Runnable callback) {
        List<Runnable> list = this.idleCallbacks;
        synchronized (list) {
            this.idleCallbacks.add(callback);
        }
        this.checkEngineStateAndNotifyCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnProcessingCallback(Runnable callback) {
        List<Runnable> list = this.processingCallbacks;
        synchronized (list) {
            this.processingCallbacks.add(callback);
        }
        this.checkEngineStateAndNotifyCallbacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEngineStateAndNotifyCallbacks() {
        TimerTask timerTask = this.idleStateNotifier;
        synchronized (timerTask) {
            if (this.isInIdleState()) {
                this.scheduleIdleStateNotification();
            } else {
                this.cancelIdleStateNotification();
                this.notifyProcessingCallbacks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProcessingCallbacks() {
        List<Runnable> list = this.processingCallbacks;
        synchronized (list) {
            this.processingCallbacks.forEach(Runnable::run);
            this.processingCallbacks.clear();
        }
    }

    private void scheduleIdleStateNotification() {
        this.idleStateNotifier = this.createIdleStateNotifier();
        try {
            TIMER.schedule(this.idleStateNotifier, 50L);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void cancelIdleStateNotification() {
        this.idleStateNotifier.cancel();
    }

    private boolean isInIdleState() {
        this.forwardToLastEvent();
        return this.lastEventPosition == this.lastProcessedPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardToLastEvent() {
        LogStreamReader logStreamReader = this.reader;
        synchronized (logStreamReader) {
            while (this.reader.hasNext()) {
                this.lastEventPosition = ((LoggedEvent)this.reader.next()).getPosition();
            }
        }
    }

    public void onCommit() {
        this.checkEngineStateAndNotifyCallbacks();
    }

    public void onProcessed(TypedRecord<?> processedCommand) {
        this.lastProcessedPosition = Math.max(this.lastProcessedPosition, processedCommand.getPosition());
        this.checkEngineStateAndNotifyCallbacks();
    }

    public void onSkipped(LoggedEvent skippedRecord) {
        this.lastProcessedPosition = Math.max(this.lastProcessedPosition, skippedRecord.getPosition());
        this.checkEngineStateAndNotifyCallbacks();
    }

    public void onReplayed(long lastReplayedEventPosition, long lastReadRecordPosition) {
        this.lastProcessedPosition = Math.max(this.lastProcessedPosition, lastReplayedEventPosition);
        this.checkEngineStateAndNotifyCallbacks();
    }

    private TimerTask createIdleStateNotifier() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (EngineStateMonitor.this.isInIdleState()) {
                    List<Runnable> list = EngineStateMonitor.this.idleCallbacks;
                    synchronized (list) {
                        EngineStateMonitor.this.idleCallbacks.forEach(Runnable::run);
                        EngineStateMonitor.this.idleCallbacks.clear();
                    }
                }
            }
        };
    }
}

