/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import io.camunda.zeebe.engine.api.InterPartitionCommandSender;
import io.camunda.zeebe.process.test.engine.CommandWriter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.buffer.BufferWriter;

final class CommandSender
implements InterPartitionCommandSender {
    private final CommandWriter writer;

    CommandSender(CommandWriter writer) {
        this.writer = writer;
    }

    public void sendCommand(int receiverPartitionId, ValueType valueType, Intent intent, BufferWriter command) {
        RecordMetadata metadata = new RecordMetadata().recordType(RecordType.COMMAND).intent(intent).valueType(valueType);
        this.writer.writeCommandWithoutKey(command, metadata);
    }

    public void sendCommand(int receiverPartitionId, ValueType valueType, Intent intent, Long recordKey, BufferWriter command) {
        RecordMetadata metadata = new RecordMetadata().recordType(RecordType.COMMAND).intent(intent).valueType(valueType);
        this.writer.writeCommandWithKey(recordKey, command, metadata);
    }
}

