/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import com.google.protobuf.GeneratedMessageV3;
import com.google.rpc.Status;
import io.camunda.zeebe.engine.api.CommandResponseWriter;
import io.camunda.zeebe.process.test.engine.GatewayRequestStore;
import io.camunda.zeebe.process.test.engine.GrpcResponseMapper;
import io.camunda.zeebe.process.test.engine.GrpcToLogStreamGateway;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.grpc.protobuf.StatusProto;
import io.grpc.stub.StreamObserver;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

class GrpcResponseWriter
implements CommandResponseWriter {
    private static long key = -1L;
    private static final DirectBuffer valueBufferView = new UnsafeBuffer();
    private static Intent intent = Intent.UNKNOWN;
    final GrpcToLogStreamGateway gateway;
    private final GatewayRequestStore gatewayRequestStore;
    private int partitionId = -1;
    private RecordType recordType = RecordType.NULL_VAL;
    private ValueType valueType = ValueType.NULL_VAL;
    private RejectionType rejectionType = RejectionType.NULL_VAL;
    private String rejectionReason = "";
    private final MutableDirectBuffer valueBuffer = new ExpandableArrayBuffer();
    private final GrpcResponseMapper responseMapper = new GrpcResponseMapper();

    public GrpcResponseWriter(GrpcToLogStreamGateway gateway, GatewayRequestStore gatewayRequestStore) {
        this.gateway = gateway;
        this.gatewayRequestStore = gatewayRequestStore;
    }

    public CommandResponseWriter partitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public CommandResponseWriter key(long key) {
        GrpcResponseWriter.key = key;
        return this;
    }

    public CommandResponseWriter intent(Intent intent) {
        GrpcResponseWriter.intent = intent;
        return this;
    }

    public CommandResponseWriter recordType(RecordType type) {
        this.recordType = type;
        return this;
    }

    public CommandResponseWriter valueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public CommandResponseWriter rejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
        return this;
    }

    public CommandResponseWriter rejectionReason(DirectBuffer rejectionReason) {
        this.rejectionReason = BufferUtil.bufferAsString((DirectBuffer)rejectionReason);
        return this;
    }

    public CommandResponseWriter valueWriter(BufferWriter value) {
        value.write(this.valueBuffer, 0);
        valueBufferView.wrap((DirectBuffer)this.valueBuffer, 0, value.getLength());
        return this;
    }

    public boolean tryWriteResponse(int requestStreamId, long requestId) {
        if (this.rejectionType != RejectionType.NULL_VAL) {
            Status rejectionResponse = this.responseMapper.createRejectionResponse(this.rejectionType, intent, this.rejectionReason);
            GatewayRequestStore.Request request = this.gatewayRequestStore.removeRequest(requestId);
            this.sendError(request, rejectionResponse);
            return true;
        }
        try {
            GatewayRequestStore.Request request = this.gatewayRequestStore.removeRequest(requestId);
            GeneratedMessageV3 response = this.responseMapper.map(request.requestType(), valueBufferView, key, intent);
            this.sendResponse(request, response);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sendResponse(GatewayRequestStore.Request request, GeneratedMessageV3 response) {
        StreamObserver<?> streamObserver = request.responseObserver();
        streamObserver.onNext((Object)response);
        streamObserver.onCompleted();
    }

    private void sendError(GatewayRequestStore.Request request, Status error) {
        StreamObserver<?> streamObserver = request.responseObserver();
        streamObserver.onError((Throwable)StatusProto.toStatusException((Status)error));
    }
}

