/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine.db;

import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.impl.ZeebeDbConstants;
import io.camunda.zeebe.process.test.engine.db.Bytes;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

final class InMemoryDbColumnFamilyIterationContext {
    private final long columnFamilyPrefix;
    private final Queue<ExpandableArrayBuffer> prefixKeyBuffers = new ArrayDeque<ExpandableArrayBuffer>(List.of(new ExpandableArrayBuffer(), new ExpandableArrayBuffer()));

    InMemoryDbColumnFamilyIterationContext(long columnFamilyPrefix) {
        this.columnFamilyPrefix = columnFamilyPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void withPrefixKey(DbKey key, Consumer<Bytes> prefixKeyConsumer) {
        if (this.prefixKeyBuffers.peek() == null) {
            throw new IllegalStateException("Currently nested prefix iterations of this depth are not supported! This will cause unexpected behavior.");
        }
        ExpandableArrayBuffer prefixKeyBuffer = this.prefixKeyBuffers.remove();
        try {
            prefixKeyBuffer.putLong(0, this.columnFamilyPrefix, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
            key.write((MutableDirectBuffer)prefixKeyBuffer, 8);
            int prefixLength = 8 + key.getLength();
            prefixKeyConsumer.accept(Bytes.fromByteArray(prefixKeyBuffer.byteArray(), prefixLength));
        }
        finally {
            this.prefixKeyBuffers.add(prefixKeyBuffer);
        }
    }
}

