/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine.db;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.KeyValuePairVisitor;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDbInconsistentException;
import io.camunda.zeebe.process.test.engine.db.Bytes;
import io.camunda.zeebe.process.test.engine.db.DbNullKey;
import io.camunda.zeebe.process.test.engine.db.FullyQualifiedKey;
import io.camunda.zeebe.process.test.engine.db.InMemoryDbColumnFamilyIterationContext;
import io.camunda.zeebe.process.test.engine.db.InMemoryDbState;
import io.camunda.zeebe.process.test.engine.db.inMemoryDbStateOperation;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

final class InMemoryDbColumnFamily<ColumnFamilyNames extends Enum<ColumnFamilyNames>, KeyType extends DbKey, ValueType extends DbValue>
implements ColumnFamily<KeyType, ValueType> {
    private final ColumnFamilyNames columnFamily;
    private final TransactionContext context;
    private final KeyType keyInstance;
    private final ValueType valueInstance;
    private final InMemoryDbColumnFamilyIterationContext iterationContext;

    InMemoryDbColumnFamily(ColumnFamilyNames columnFamily, TransactionContext context, KeyType keyInstance, ValueType valueInstance) {
        this.columnFamily = columnFamily;
        this.context = context;
        this.keyInstance = keyInstance;
        this.valueInstance = valueInstance;
        this.iterationContext = new InMemoryDbColumnFamilyIterationContext(((Enum)columnFamily).ordinal());
    }

    private void ensureInOpenTransaction(TransactionContext context, inMemoryDbStateOperation operation) {
        context.runInTransaction(() -> operation.run((InMemoryDbState)context.getCurrentTransaction()));
    }

    public void insert(KeyType key, ValueType value) {
        this.ensureInOpenTransaction(this.context, state -> {
            FullyQualifiedKey fullyQualifiedKey = new FullyQualifiedKey((Enum)this.columnFamily, (DbKey)key);
            if (state.contains(fullyQualifiedKey)) {
                throw new ZeebeDbInconsistentException("Key " + this.keyInstance + " in ColumnFamily " + this.columnFamily + " already exists");
            }
            state.put(fullyQualifiedKey, (DbValue)value);
        });
    }

    public void update(KeyType key, ValueType value) {
        this.ensureInOpenTransaction(this.context, state -> {
            FullyQualifiedKey fullyQualifiedKey = new FullyQualifiedKey((Enum)this.columnFamily, (DbKey)key);
            if (!state.contains(fullyQualifiedKey)) {
                throw new ZeebeDbInconsistentException("Key " + this.keyInstance + " in ColumnFamily " + this.columnFamily + " does not exist");
            }
            state.put(fullyQualifiedKey, (DbValue)value);
        });
    }

    public void upsert(KeyType key, ValueType value) {
        this.ensureInOpenTransaction(this.context, state -> state.put(new FullyQualifiedKey((Enum)this.columnFamily, (DbKey)key), (DbValue)value));
    }

    public ValueType get(KeyType key) {
        AtomicReference<Object> valueBufferRef = new AtomicReference<Object>(null);
        this.ensureInOpenTransaction(this.context, state -> valueBufferRef.set(this.getValue(state, (DbKey)key)));
        DirectBuffer valueBuffer = valueBufferRef.get();
        if (valueBuffer != null) {
            this.valueInstance.wrap(valueBuffer, 0, valueBuffer.capacity());
            return this.valueInstance;
        }
        return null;
    }

    public void forEach(Consumer<ValueType> consumer) {
        this.forEach(this.context, (key, value) -> consumer.accept(value));
    }

    public void forEach(BiConsumer<KeyType, ValueType> consumer) {
        this.forEach(this.context, consumer);
    }

    public void whileTrue(KeyType startAtKey, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(this.context, (DbKey)startAtKey, DbNullKey.INSTANCE, this.keyInstance, this.valueInstance, visitor);
    }

    public void whileTrue(KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(this.context, DbNullKey.INSTANCE, this.keyInstance, this.valueInstance, visitor);
    }

    public void whileEqualPrefix(DbKey keyPrefix, BiConsumer<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(this.context, keyPrefix, this.keyInstance, this.valueInstance, new Visitor<KeyType, ValueType>(visitor));
    }

    public void whileEqualPrefix(DbKey keyPrefix, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(this.context, keyPrefix, this.keyInstance, this.valueInstance, visitor);
    }

    public void whileEqualPrefix(DbKey keyPrefix, KeyType startAtKey, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(this.context, (DbKey)startAtKey, keyPrefix, this.keyInstance, this.valueInstance, visitor);
    }

    public void deleteExisting(KeyType key) {
        this.ensureInOpenTransaction(this.context, state -> {
            FullyQualifiedKey fullyQualifiedKey = new FullyQualifiedKey((Enum)this.columnFamily, (DbKey)key);
            if (!state.contains(fullyQualifiedKey)) {
                throw new ZeebeDbInconsistentException("Key " + this.keyInstance + " in ColumnFamily " + this.columnFamily + " does not exist");
            }
            state.delete(fullyQualifiedKey);
        });
    }

    public void deleteIfExists(KeyType key) {
        this.ensureInOpenTransaction(this.context, state -> {
            FullyQualifiedKey fullyQualifiedKey = new FullyQualifiedKey((Enum)this.columnFamily, (DbKey)key);
            state.delete(fullyQualifiedKey);
        });
    }

    public boolean exists(KeyType key) {
        AtomicBoolean exists = new AtomicBoolean(true);
        this.ensureInOpenTransaction(this.context, state -> exists.set(this.getValue(state, (DbKey)key) != null));
        return exists.get();
    }

    public boolean isEmpty() {
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        this.whileEqualPrefix((DbKey)DbNullKey.INSTANCE, (key, value) -> {
            isEmpty.set(false);
            return false;
        });
        return isEmpty.get();
    }

    public long count() {
        return this.countEachInPrefix(DbNullKey.INSTANCE);
    }

    public long countEqualPrefix(DbKey prefix) {
        return this.countEachInPrefix(prefix);
    }

    private DirectBuffer getValue(InMemoryDbState state, DbKey key) {
        FullyQualifiedKey fullyQualifiedKey = new FullyQualifiedKey((Enum)this.columnFamily, key);
        byte[] value = state.get(fullyQualifiedKey);
        if (value != null) {
            return BufferUtil.wrapArray((byte[])value);
        }
        return null;
    }

    private void forEach(TransactionContext context, BiConsumer<KeyType, ValueType> consumer) {
        this.whileEqualPrefix(context, this.keyInstance, this.valueInstance, consumer);
    }

    private void whileEqualPrefix(TransactionContext context, KeyType keyInstance, ValueType valueInstance, BiConsumer<KeyType, ValueType> consumer) {
        this.whileEqualPrefix(context, DbNullKey.INSTANCE, keyInstance, valueInstance, new Visitor<KeyType, ValueType>(consumer));
    }

    private void whileEqualPrefix(TransactionContext context, DbKey prefix, KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        this.whileEqualPrefix(context, prefix, prefix, keyInstance, valueInstance, visitor);
    }

    private long countEachInPrefix(DbKey prefix) {
        DbKey seekTarget = Objects.requireNonNull(prefix);
        AtomicLong count = new AtomicLong(0L);
        this.iterationContext.withPrefixKey(prefix, prefixKey -> this.ensureInOpenTransaction(this.context, state -> {
            Map.Entry<Bytes, Bytes> entry;
            byte[] keyBytes;
            ByteBuffer seekTargetBuffer = this.iterationContext.keyWithColumnFamily(seekTarget);
            byte[] seekTargetBytes = seekTargetBuffer.array();
            Iterator<Map.Entry<Bytes, Bytes>> iterator = state.newIterator().seek(seekTargetBytes, seekTargetBytes.length).iterate();
            byte[] prefixKeyBytes = prefixKey.toBytes();
            while (iterator.hasNext() && BufferUtil.startsWith((byte[])prefixKeyBytes, (int)0, (int)prefixKeyBytes.length, (byte[])(keyBytes = (entry = iterator.next()).getKey().toBytes()), (int)0, (int)keyBytes.length)) {
                count.getAndIncrement();
            }
        }));
        return count.get();
    }

    private void whileEqualPrefix(TransactionContext context, DbKey startAt, DbKey prefix, KeyType keyInstance, ValueType valueInstance, KeyValuePairVisitor<KeyType, ValueType> visitor) {
        DbKey seekTarget = Objects.requireNonNullElse(startAt, prefix);
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(visitor);
        this.iterationContext.withPrefixKey(prefix, prefixKey -> this.ensureInOpenTransaction(context, state -> {
            ByteBuffer seekTargetBuffer = this.iterationContext.keyWithColumnFamily(seekTarget);
            byte[] seekTargetBytes = seekTargetBuffer.array();
            Iterator<Map.Entry<Bytes, Bytes>> iterator = state.newIterator().seek(seekTargetBytes, seekTargetBytes.length).iterate();
            byte[] prefixKeyBytes = prefixKey.toBytes();
            while (iterator.hasNext()) {
                Map.Entry<Bytes, Bytes> entry = iterator.next();
                byte[] keyBytes = entry.getKey().toBytes();
                if (!BufferUtil.startsWith((byte[])prefixKeyBytes, (int)0, (int)prefixKeyBytes.length, (byte[])keyBytes, (int)0, (int)keyBytes.length)) continue;
                DirectBuffer keyViewBuffer = FullyQualifiedKey.wrapKey(entry.getKey().toBytes());
                keyInstance.wrap(keyViewBuffer, 0, keyViewBuffer.capacity());
                MutableDirectBuffer valueViewBuffer = BufferUtil.wrapArray((byte[])entry.getValue().toBytes());
                valueInstance.wrap((DirectBuffer)valueViewBuffer, 0, valueViewBuffer.capacity());
                boolean shouldVisitNext = visitor.visit(keyInstance, valueInstance);
                if (shouldVisitNext) continue;
                return;
            }
        }));
    }

    private static final class Visitor<KeyType extends DbKey, ValueType extends DbValue>
    implements KeyValuePairVisitor<KeyType, ValueType> {
        private final BiConsumer<KeyType, ValueType> delegate;

        private Visitor(BiConsumer<KeyType, ValueType> delegate) {
            this.delegate = delegate;
        }

        public boolean visit(KeyType key, ValueType value) {
            this.delegate.accept(key, value);
            return true;
        }
    }
}

