/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import com.google.protobuf.GeneratedMessageV3;
import com.google.rpc.Status;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceResultRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

class GrpcResponseMapper {
    private DirectBuffer valueBufferView;
    private long key;
    private Intent intent;
    private final Map<Class<? extends GeneratedMessageV3>, Callable<GeneratedMessageV3>> mappers = Map.ofEntries(Map.entry(GatewayOuterClass.ActivateJobsRequest.class, this::createJobBatchResponse), Map.entry(GatewayOuterClass.CancelProcessInstanceRequest.class, this::createCancelInstanceResponse), Map.entry(GatewayOuterClass.CompleteJobRequest.class, this::createCompleteJobResponse), Map.entry(GatewayOuterClass.CreateProcessInstanceRequest.class, this::createProcessInstanceResponse), Map.entry(GatewayOuterClass.CreateProcessInstanceWithResultRequest.class, this::createProcessInstanceWithResultResponse), Map.entry(GatewayOuterClass.EvaluateDecisionRequest.class, this::evaluateDecisionResponse), Map.entry(GatewayOuterClass.DeployProcessRequest.class, this::createDeployResponse), Map.entry(GatewayOuterClass.DeployResourceRequest.class, this::createDeployResourceResponse), Map.entry(GatewayOuterClass.FailJobRequest.class, this::createFailJobResponse), Map.entry(GatewayOuterClass.ThrowErrorRequest.class, this::createJobThrowErrorResponse), Map.entry(GatewayOuterClass.PublishMessageRequest.class, this::createMessageResponse), Map.entry(GatewayOuterClass.ResolveIncidentRequest.class, this::createResolveIncidentResponse), Map.entry(GatewayOuterClass.SetVariablesRequest.class, this::createSetVariablesResponse), Map.entry(GatewayOuterClass.UpdateJobRetriesRequest.class, this::createJobUpdateRetriesResponse), Map.entry(GatewayOuterClass.UpdateJobTimeoutRequest.class, this::createJobUpdateTimeOutResponse), Map.entry(GatewayOuterClass.ModifyProcessInstanceRequest.class, this::createModifyProcessInstanceResponse), Map.entry(GatewayOuterClass.BroadcastSignalRequest.class, this::createBroadcastSignalResponse));

    GrpcResponseMapper() {
    }

    GeneratedMessageV3 map(Class<? extends GeneratedMessageV3> requestType, DirectBuffer valueBufferView, long key, Intent intent) {
        try {
            this.valueBufferView = valueBufferView;
            this.key = key;
            this.intent = intent;
            return this.mappers.get(requestType).call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated(since="8.0.0")
    private GatewayOuterClass.DeployProcessResponse createDeployResponse() {
        DeploymentRecord deployment = new DeploymentRecord();
        deployment.wrap(this.valueBufferView);
        return GatewayOuterClass.DeployProcessResponse.newBuilder().setKey(this.key).addAllProcesses((Iterable)deployment.getProcessesMetadata().stream().map(metadata -> GatewayOuterClass.ProcessMetadata.newBuilder().setProcessDefinitionKey(metadata.getProcessDefinitionKey()).setBpmnProcessId(metadata.getBpmnProcessId()).setVersion(metadata.getVersion()).setResourceName(metadata.getResourceName()).build()).collect(Collectors.toList())).build();
    }

    private GeneratedMessageV3 createDeployResourceResponse() {
        DeploymentRecord deployment = new DeploymentRecord();
        deployment.wrap(this.valueBufferView);
        GatewayOuterClass.DeployResourceResponse.Builder builder = GatewayOuterClass.DeployResourceResponse.newBuilder().setKey(this.key);
        deployment.getProcessesMetadata().stream().map(metadata -> GatewayOuterClass.ProcessMetadata.newBuilder().setBpmnProcessId(metadata.getBpmnProcessId()).setVersion(metadata.getVersion()).setProcessDefinitionKey(metadata.getProcessDefinitionKey()).setResourceName(metadata.getResourceName()).build()).forEach(metadata -> builder.addDeploymentsBuilder().setProcess(metadata));
        deployment.decisionsMetadata().stream().map(metadata -> GatewayOuterClass.DecisionMetadata.newBuilder().setDmnDecisionId(metadata.getDecisionId()).setDmnDecisionName(metadata.getDecisionName()).setVersion(metadata.getVersion()).setDecisionKey(metadata.getDecisionKey()).setDmnDecisionRequirementsId(metadata.getDecisionRequirementsId()).setDecisionRequirementsKey(metadata.getDecisionRequirementsKey()).build()).forEach(metadata -> builder.addDeploymentsBuilder().setDecision(metadata));
        deployment.decisionRequirementsMetadata().stream().map(metadata -> GatewayOuterClass.DecisionRequirementsMetadata.newBuilder().setDmnDecisionRequirementsId(metadata.getDecisionRequirementsId()).setDmnDecisionRequirementsName(metadata.getDecisionRequirementsName()).setVersion(metadata.getDecisionRequirementsVersion()).setDecisionRequirementsKey(metadata.getDecisionRequirementsKey()).setResourceName(metadata.getResourceName()).build()).forEach(metadata -> builder.addDeploymentsBuilder().setDecisionRequirements(metadata));
        deployment.formMetadata().stream().map(metadata -> GatewayOuterClass.FormMetadata.newBuilder().setFormId(metadata.getFormId()).setVersion(metadata.getVersion()).setFormKey(metadata.getFormKey()).setResourceName(metadata.getResourceName()).setTenantId(metadata.getTenantId())).forEach(metadata -> builder.addDeploymentsBuilder().setForm(metadata));
        return builder.build();
    }

    private GeneratedMessageV3 evaluateDecisionResponse() {
        DecisionEvaluationRecord evaluationRecord = new DecisionEvaluationRecord();
        evaluationRecord.wrap(this.valueBufferView);
        List evaluatedDecisions = evaluationRecord.evaluatedDecisions().stream().map(evaluatedDecision -> GatewayOuterClass.EvaluatedDecision.newBuilder().setDecisionId(evaluatedDecision.getDecisionId()).setDecisionKey(evaluatedDecision.getDecisionKey()).setDecisionName(evaluatedDecision.getDecisionName()).setDecisionVersion(evaluatedDecision.getDecisionVersion()).setDecisionType(evaluatedDecision.getDecisionType()).setDecisionOutput(evaluatedDecision.getDecisionOutput()).addAllEvaluatedInputs((Iterable)evaluatedDecision.evaluatedInputs().stream().map(evaluatedInput -> GatewayOuterClass.EvaluatedDecisionInput.newBuilder().setInputValue(evaluatedInput.getInputValue()).setInputName(evaluatedInput.getInputName()).setInputId(evaluatedInput.getInputId()).build()).collect(Collectors.toList())).addAllMatchedRules((Iterable)evaluatedDecision.matchedRules().stream().map(matchedRule -> GatewayOuterClass.MatchedDecisionRule.newBuilder().setRuleIndex(matchedRule.getRuleIndex()).setRuleId(matchedRule.getRuleId()).addAllEvaluatedOutputs((Iterable)matchedRule.evaluatedOutputs().stream().map(evaluatedOutput -> GatewayOuterClass.EvaluatedDecisionOutput.newBuilder().setOutputValue(evaluatedOutput.getOutputValue()).setOutputName(evaluatedOutput.getOutputName()).setOutputId(evaluatedOutput.getOutputId()).build()).collect(Collectors.toList())).build()).collect(Collectors.toList())).build()).collect(Collectors.toList());
        return GatewayOuterClass.EvaluateDecisionResponse.newBuilder().setDecisionId(evaluationRecord.getDecisionId()).setDecisionKey(evaluationRecord.getDecisionKey()).setDecisionName(evaluationRecord.getDecisionName()).setDecisionVersion(evaluationRecord.getDecisionVersion()).setDecisionRequirementsId(evaluationRecord.getDecisionRequirementsId()).setDecisionRequirementsKey(evaluationRecord.getDecisionRequirementsKey()).setDecisionOutput(evaluationRecord.getDecisionOutput()).setFailedDecisionId(evaluationRecord.getFailedDecisionId()).setFailureMessage(evaluationRecord.getEvaluationFailureMessage()).addAllEvaluatedDecisions(evaluatedDecisions).build();
    }

    private GeneratedMessageV3 createProcessInstanceResponse() {
        ProcessInstanceCreationRecord processInstance = new ProcessInstanceCreationRecord();
        processInstance.wrap(this.valueBufferView);
        return GatewayOuterClass.CreateProcessInstanceResponse.newBuilder().setProcessInstanceKey(processInstance.getProcessInstanceKey()).setProcessDefinitionKey(processInstance.getProcessDefinitionKey()).setBpmnProcessId(processInstance.getBpmnProcessId()).setVersion(processInstance.getVersion()).build();
    }

    private GeneratedMessageV3 createProcessInstanceWithResultResponse() {
        ProcessInstanceResultRecord processInstanceResult = new ProcessInstanceResultRecord();
        processInstanceResult.wrap(this.valueBufferView);
        return GatewayOuterClass.CreateProcessInstanceWithResultResponse.newBuilder().setProcessInstanceKey(processInstanceResult.getProcessInstanceKey()).setProcessDefinitionKey(processInstanceResult.getProcessDefinitionKey()).setBpmnProcessId(processInstanceResult.getBpmnProcessId()).setVersion(processInstanceResult.getVersion()).setVariables(MsgPackConverter.convertToJson((DirectBuffer)processInstanceResult.getVariablesBuffer())).build();
    }

    private GeneratedMessageV3 createCancelInstanceResponse() {
        return GatewayOuterClass.CancelProcessInstanceResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createModifyProcessInstanceResponse() {
        return GatewayOuterClass.ModifyProcessInstanceResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createBroadcastSignalResponse() {
        SignalRecord signal = new SignalRecord();
        signal.wrap(this.valueBufferView);
        return GatewayOuterClass.BroadcastSignalResponse.newBuilder().setKey(this.key).build();
    }

    private GeneratedMessageV3 createResolveIncidentResponse() {
        IncidentRecord incident = new IncidentRecord();
        incident.wrap(this.valueBufferView);
        return GatewayOuterClass.ResolveIncidentResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createSetVariablesResponse() {
        VariableDocumentRecord variableDocumentRecord = new VariableDocumentRecord();
        variableDocumentRecord.wrap(this.valueBufferView);
        return GatewayOuterClass.SetVariablesResponse.newBuilder().setKey(this.key).build();
    }

    private GeneratedMessageV3 createMessageResponse() {
        return GatewayOuterClass.PublishMessageResponse.newBuilder().setKey(this.key).build();
    }

    private GeneratedMessageV3 createJobBatchResponse() {
        JobBatchRecord jobBatch = new JobBatchRecord();
        jobBatch.wrap(this.valueBufferView);
        HashMap<Long, JobRecord> jobsWithKeys = new HashMap<Long, JobRecord>();
        for (int index = 0; index < jobBatch.getJobKeys().size(); ++index) {
            Long key = (Long)jobBatch.getJobKeys().get(index);
            JobRecord value = (JobRecord)jobBatch.getJobs().get(index);
            jobsWithKeys.put(key, value);
        }
        return GatewayOuterClass.ActivateJobsResponse.newBuilder().addAllJobs((Iterable)jobsWithKeys.entrySet().stream().map(entry -> {
            JobRecord job = (JobRecord)entry.getValue();
            return GatewayOuterClass.ActivatedJob.newBuilder().setKey(((Long)entry.getKey()).longValue()).setType(job.getType()).setRetries(job.getRetries()).setWorker(job.getWorker()).setDeadline(job.getDeadline()).setProcessDefinitionKey(job.getProcessDefinitionKey()).setBpmnProcessId(job.getBpmnProcessId()).setProcessDefinitionVersion(job.getProcessDefinitionVersion()).setProcessInstanceKey(job.getProcessInstanceKey()).setElementId(job.getElementId()).setElementInstanceKey(job.getElementInstanceKey()).setCustomHeaders(MsgPackConverter.convertToJson((DirectBuffer)job.getCustomHeadersBuffer())).setVariables(MsgPackConverter.convertToJson((DirectBuffer)job.getVariablesBuffer())).build();
        }).collect(Collectors.toList())).build();
    }

    private GeneratedMessageV3 createCompleteJobResponse() {
        return GatewayOuterClass.CompleteJobResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createFailJobResponse() {
        return GatewayOuterClass.FailJobResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createJobThrowErrorResponse() {
        return GatewayOuterClass.ThrowErrorResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createJobUpdateRetriesResponse() {
        return GatewayOuterClass.UpdateJobRetriesResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createJobUpdateTimeOutResponse() {
        return GatewayOuterClass.UpdateJobTimeoutResponse.newBuilder().build();
    }

    Status createRejectionResponse(RejectionType rejectionType, Intent intent, String rejectionReason) {
        int statusCode = switch (rejectionType) {
            case RejectionType.INVALID_ARGUMENT -> 3;
            case RejectionType.NOT_FOUND -> 5;
            case RejectionType.ALREADY_EXISTS -> 6;
            case RejectionType.INVALID_STATE -> 9;
            case RejectionType.PROCESSING_ERROR -> 13;
            default -> 2;
        };
        return Status.newBuilder().setMessage(String.format("Command '%s' rejected with code '%s': %s", intent, rejectionType, rejectionReason)).setCode(statusCode).build();
    }
}

