/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.process.test.engine.CommandWriter;
import io.camunda.zeebe.process.test.engine.GatewayRequestStore;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationActivateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationTerminateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationVariableInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.resource.ResourceDeletionRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.camunda.zeebe.util.VersionUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.grpc.stub.StreamObserver;
import java.util.List;
import org.agrona.DirectBuffer;

class GrpcToLogStreamGateway
extends GatewayGrpc.GatewayImplBase {
    private final CommandWriter writer;
    private final int partitionId;
    private final int partitionCount;
    private final int port;
    private final GatewayRequestStore gatewayRequestStore;

    public GrpcToLogStreamGateway(CommandWriter writer, int partitionId, int partitionCount, int port, GatewayRequestStore gatewayRequestStore) {
        this.writer = writer;
        this.partitionId = partitionId;
        this.partitionCount = partitionCount;
        this.port = port;
        this.gatewayRequestStore = gatewayRequestStore;
    }

    public void activateJobs(GatewayOuterClass.ActivateJobsRequest request, StreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB_BATCH).intent((Intent)JobBatchIntent.ACTIVATE);
        JobBatchRecord jobBatchRecord = new JobBatchRecord();
        jobBatchRecord.setType(request.getType());
        jobBatchRecord.setWorker(request.getWorker());
        jobBatchRecord.setTimeout(request.getTimeout());
        jobBatchRecord.setMaxJobsToActivate(request.getMaxJobsToActivate());
        this.writer.writeCommandWithoutKey((UnifiedRecordValue)jobBatchRecord, recordMetadata);
    }

    public void cancelProcessInstance(GatewayOuterClass.CancelProcessInstanceRequest request, StreamObserver<GatewayOuterClass.CancelProcessInstanceResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.PROCESS_INSTANCE).intent((Intent)ProcessInstanceIntent.CANCEL);
        ProcessInstanceRecord processInstanceRecord = new ProcessInstanceRecord();
        processInstanceRecord.setProcessInstanceKey(request.getProcessInstanceKey());
        this.writer.writeCommandWithKey(request.getProcessInstanceKey(), (UnifiedRecordValue)processInstanceRecord, recordMetadata);
    }

    public void completeJob(GatewayOuterClass.CompleteJobRequest request, StreamObserver<GatewayOuterClass.CompleteJobResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB).intent((Intent)JobIntent.COMPLETE);
        JobRecord jobRecord = new JobRecord();
        String variables = request.getVariables();
        if (!variables.isEmpty()) {
            jobRecord.setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)variables)));
        }
        this.writer.writeCommandWithKey(request.getJobKey(), (UnifiedRecordValue)jobRecord, recordMetadata);
    }

    public void createProcessInstance(GatewayOuterClass.CreateProcessInstanceRequest request, StreamObserver<GatewayOuterClass.CreateProcessInstanceResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.PROCESS_INSTANCE_CREATION).intent((Intent)ProcessInstanceCreationIntent.CREATE);
        ProcessInstanceCreationRecord processInstanceCreationRecord = this.createProcessInstanceCreationRecord(request);
        this.writer.writeCommandWithoutKey((UnifiedRecordValue)processInstanceCreationRecord, recordMetadata);
    }

    public void createProcessInstanceWithResult(GatewayOuterClass.CreateProcessInstanceWithResultRequest request, StreamObserver<GatewayOuterClass.CreateProcessInstanceWithResultResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.PROCESS_INSTANCE_CREATION).intent((Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT);
        ProcessInstanceCreationRecord processInstanceCreationRecord = this.createProcessInstanceCreationRecord(request.getRequest());
        processInstanceCreationRecord.setFetchVariables((List)request.getFetchVariablesList());
        this.writer.writeCommandWithoutKey((UnifiedRecordValue)processInstanceCreationRecord, recordMetadata);
    }

    public void evaluateDecision(GatewayOuterClass.EvaluateDecisionRequest request, StreamObserver<GatewayOuterClass.EvaluateDecisionResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.DECISION_EVALUATION).intent((Intent)DecisionEvaluationIntent.EVALUATE);
        DecisionEvaluationRecord decisionEvaluationRecord = this.createDecisionEvaluationRecord(request);
        this.writer.writeCommandWithoutKey((UnifiedRecordValue)decisionEvaluationRecord, recordMetadata);
    }

    public void deployProcess(GatewayOuterClass.DeployProcessRequest request, StreamObserver<GatewayOuterClass.DeployProcessResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.DEPLOYMENT).intent((Intent)DeploymentIntent.CREATE);
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        ValueArray resources = deploymentRecord.resources();
        request.getProcessesList().forEach(processRequestObject -> ((DeploymentResource)resources.add()).setResourceName(processRequestObject.getName()).setResource(processRequestObject.getDefinition().toByteArray()));
        this.writer.writeCommandWithoutKey((UnifiedRecordValue)deploymentRecord, recordMetadata);
    }

    public void deployResource(GatewayOuterClass.DeployResourceRequest request, StreamObserver<GatewayOuterClass.DeployResourceResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.DEPLOYMENT).intent((Intent)DeploymentIntent.CREATE);
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        ValueArray resources = deploymentRecord.resources();
        request.getResourcesList().forEach(resource -> ((DeploymentResource)resources.add()).setResourceName(resource.getName()).setResource(resource.getContent().toByteArray()));
        this.writer.writeCommandWithoutKey((UnifiedRecordValue)deploymentRecord, recordMetadata);
    }

    public void failJob(GatewayOuterClass.FailJobRequest request, StreamObserver<GatewayOuterClass.FailJobResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB).intent((Intent)JobIntent.FAIL);
        JobRecord jobRecord = new JobRecord();
        jobRecord.setRetries(request.getRetries());
        jobRecord.setErrorMessage(request.getErrorMessage());
        jobRecord.setRetryBackoff(request.getRetryBackOff());
        this.writer.writeCommandWithKey(request.getJobKey(), (UnifiedRecordValue)jobRecord, recordMetadata);
    }

    public void throwError(GatewayOuterClass.ThrowErrorRequest request, StreamObserver<GatewayOuterClass.ThrowErrorResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB).intent((Intent)JobIntent.THROW_ERROR);
        JobRecord jobRecord = new JobRecord();
        jobRecord.setErrorCode(BufferUtil.wrapString((String)request.getErrorCode()));
        jobRecord.setErrorMessage(request.getErrorMessage());
        this.writer.writeCommandWithKey(request.getJobKey(), (UnifiedRecordValue)jobRecord, recordMetadata);
    }

    public void publishMessage(GatewayOuterClass.PublishMessageRequest request, StreamObserver<GatewayOuterClass.PublishMessageResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.MESSAGE).intent((Intent)MessageIntent.PUBLISH);
        MessageRecord messageRecord = new MessageRecord();
        messageRecord.setCorrelationKey(request.getCorrelationKey());
        messageRecord.setMessageId(request.getMessageId());
        messageRecord.setName(request.getName());
        messageRecord.setTimeToLive(request.getTimeToLive());
        String variables = request.getVariables();
        if (!variables.isEmpty()) {
            messageRecord.setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)variables)));
        }
        this.writer.writeCommandWithoutKey((UnifiedRecordValue)messageRecord, recordMetadata);
    }

    public void resolveIncident(GatewayOuterClass.ResolveIncidentRequest request, StreamObserver<GatewayOuterClass.ResolveIncidentResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.INCIDENT).intent((Intent)IncidentIntent.RESOLVE);
        IncidentRecord incidentRecord = new IncidentRecord();
        this.writer.writeCommandWithKey(request.getIncidentKey(), (UnifiedRecordValue)incidentRecord, recordMetadata);
    }

    public void setVariables(GatewayOuterClass.SetVariablesRequest request, StreamObserver<GatewayOuterClass.SetVariablesResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.VARIABLE_DOCUMENT).intent((Intent)VariableDocumentIntent.UPDATE);
        VariableDocumentRecord variableDocumentRecord = new VariableDocumentRecord();
        String variables = request.getVariables();
        if (!variables.isEmpty()) {
            variableDocumentRecord.setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)variables)));
        }
        variableDocumentRecord.setScopeKey(request.getElementInstanceKey());
        variableDocumentRecord.setUpdateSemantics(request.getLocal() ? VariableDocumentUpdateSemantic.LOCAL : VariableDocumentUpdateSemantic.PROPAGATE);
        this.writer.writeCommandWithoutKey((UnifiedRecordValue)variableDocumentRecord, recordMetadata);
    }

    public void topology(GatewayOuterClass.TopologyRequest request, StreamObserver<GatewayOuterClass.TopologyResponse> responseObserver) {
        GatewayOuterClass.Partition partition = GatewayOuterClass.Partition.newBuilder().setHealth(GatewayOuterClass.Partition.PartitionBrokerHealth.HEALTHY).setRole(GatewayOuterClass.Partition.PartitionBrokerRole.LEADER).setPartitionId(this.partitionId).build();
        GatewayOuterClass.BrokerInfo brokerInfo = GatewayOuterClass.BrokerInfo.newBuilder().addPartitions(partition).setHost("0.0.0.0").setPort(this.port).setVersion(VersionUtil.getVersion()).build();
        GatewayOuterClass.TopologyResponse topologyResponse = GatewayOuterClass.TopologyResponse.newBuilder().addBrokers(brokerInfo).setClusterSize(1).setPartitionsCount(this.partitionCount).setReplicationFactor(1).setGatewayVersion(VersionUtil.getVersion()).build();
        responseObserver.onNext((Object)topologyResponse);
        responseObserver.onCompleted();
    }

    public void updateJobRetries(GatewayOuterClass.UpdateJobRetriesRequest request, StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB).intent((Intent)JobIntent.UPDATE_RETRIES);
        JobRecord jobRecord = new JobRecord();
        jobRecord.setRetries(request.getRetries());
        this.writer.writeCommandWithKey(request.getJobKey(), (UnifiedRecordValue)jobRecord, recordMetadata);
    }

    public void modifyProcessInstance(GatewayOuterClass.ModifyProcessInstanceRequest request, StreamObserver<GatewayOuterClass.ModifyProcessInstanceResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.PROCESS_INSTANCE_MODIFICATION).intent((Intent)ProcessInstanceModificationIntent.MODIFY);
        ProcessInstanceModificationRecord record = this.createProcessInstanceModificationRecord(request);
        this.writer.writeCommandWithKey(request.getProcessInstanceKey(), (UnifiedRecordValue)record, recordMetadata);
    }

    public void updateJobTimeout(GatewayOuterClass.UpdateJobTimeoutRequest request, StreamObserver<GatewayOuterClass.UpdateJobTimeoutResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        RecordMetadata recordMetadata = this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.JOB).intent((Intent)JobIntent.UPDATE_TIMEOUT);
        JobRecord jobRecord = new JobRecord();
        jobRecord.setTimeout(request.getTimeout());
        this.writer.writeCommandWithKey(request.getJobKey(), (UnifiedRecordValue)jobRecord, recordMetadata);
    }

    public void deleteResource(GatewayOuterClass.DeleteResourceRequest request, StreamObserver<GatewayOuterClass.DeleteResourceResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        this.writer.writeCommandWithoutKey((UnifiedRecordValue)new ResourceDeletionRecord().setResourceKey(request.getResourceKey()), this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.RESOURCE_DELETION).intent((Intent)ResourceDeletionIntent.DELETE));
    }

    public void broadcastSignal(GatewayOuterClass.BroadcastSignalRequest request, StreamObserver<GatewayOuterClass.BroadcastSignalResponse> responseObserver) {
        Long requestId = this.gatewayRequestStore.registerNewRequest(request.getClass(), responseObserver);
        SignalRecord command = new SignalRecord().setSignalName(request.getSignalName());
        if (!request.getVariables().isEmpty()) {
            command.setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)request.getVariables())));
        }
        this.writer.writeCommandWithoutKey((UnifiedRecordValue)command, this.prepareRecordMetadata().requestId(requestId.longValue()).valueType(ValueType.SIGNAL).intent((Intent)SignalIntent.BROADCAST));
    }

    private ProcessInstanceModificationRecord createProcessInstanceModificationRecord(GatewayOuterClass.ModifyProcessInstanceRequest request) {
        ProcessInstanceModificationActivateInstruction instruction;
        ProcessInstanceModificationRecord record = new ProcessInstanceModificationRecord();
        record.setProcessInstanceKey(request.getProcessInstanceKey());
        for (GatewayOuterClass.ModifyProcessInstanceRequest.ActivateInstruction activate : request.getActivateInstructionsList()) {
            instruction = new ProcessInstanceModificationActivateInstruction().setElementId(activate.getElementId()).setAncestorScopeKey(activate.getAncestorElementInstanceKey());
            for (GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variable : activate.getVariableInstructionsList()) {
                instruction.addVariableInstruction(new ProcessInstanceModificationVariableInstruction().setElementId(variable.getScopeId()).setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)variable.getVariables()))));
            }
            record.addActivateInstruction(instruction);
        }
        for (GatewayOuterClass.ModifyProcessInstanceRequest.TerminateInstruction terminate : request.getTerminateInstructionsList()) {
            instruction = new ProcessInstanceModificationTerminateInstruction().setElementInstanceKey(terminate.getElementInstanceKey());
            record.addTerminateInstruction((ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue)instruction);
        }
        return record;
    }

    private RecordMetadata prepareRecordMetadata() {
        return new RecordMetadata().recordType(RecordType.COMMAND).requestStreamId(this.partitionId);
    }

    private ProcessInstanceCreationRecord createProcessInstanceCreationRecord(GatewayOuterClass.CreateProcessInstanceRequest request) {
        ProcessInstanceCreationRecord processInstanceCreationRecord = new ProcessInstanceCreationRecord();
        processInstanceCreationRecord.setBpmnProcessId(request.getBpmnProcessId());
        processInstanceCreationRecord.setVersion(request.getVersion());
        processInstanceCreationRecord.setProcessDefinitionKey(request.getProcessDefinitionKey());
        request.getStartInstructionsList().stream().map(startInstruction -> new ProcessInstanceCreationStartInstruction().setElementId(startInstruction.getElementId())).forEach(arg_0 -> ((ProcessInstanceCreationRecord)processInstanceCreationRecord).addStartInstruction(arg_0));
        String variables = request.getVariables();
        if (!variables.isEmpty()) {
            processInstanceCreationRecord.setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)variables)));
        }
        return processInstanceCreationRecord;
    }

    private DecisionEvaluationRecord createDecisionEvaluationRecord(GatewayOuterClass.EvaluateDecisionRequest request) {
        DecisionEvaluationRecord record = new DecisionEvaluationRecord();
        if (request.getDecisionKey() > 0L) {
            record.setDecisionKey(request.getDecisionKey());
        } else {
            record.setDecisionId(request.getDecisionId());
        }
        String variables = request.getVariables();
        if (!variables.isEmpty()) {
            record.setVariables((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack((String)variables)));
        }
        return record;
    }

    public String getAddress() {
        return "0.0.0.0:" + this.port;
    }
}

