/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine.db;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.process.test.engine.db.Bytes;
import io.camunda.zeebe.process.test.engine.db.DbNullKey;
import io.camunda.zeebe.process.test.engine.db.InMemoryDbColumnFamily;
import io.camunda.zeebe.process.test.engine.db.InMemoryDbTransactionContext;
import io.camunda.zeebe.protocol.EnumValue;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.camunda.zeebe.util.micrometer.StatefulMeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.io.File;
import java.util.Optional;
import java.util.TreeMap;

final class InMemoryDb<ColumnFamilyType extends Enum<? extends EnumValue>>
implements ZeebeDb<ColumnFamilyType> {
    private final TreeMap<Bytes, Bytes> database = new TreeMap();
    private final StatefulMeterRegistry meterRegistry;

    public InMemoryDb(StatefulMeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public <KeyType extends DbKey, ValueType extends DbValue> ColumnFamily<KeyType, ValueType> createColumnFamily(ColumnFamilyType columnFamily, TransactionContext context, KeyType keyInstance, ValueType valueInstance) {
        return new InMemoryDbColumnFamily<ColumnFamilyType, KeyType, ValueType>(columnFamily, context, keyInstance, valueInstance);
    }

    public void createSnapshot(File snapshotDir) {
        throw new IllegalStateException("No snapshots supported");
    }

    public Optional<String> getProperty(String propertyName) {
        return Optional.empty();
    }

    public TransactionContext createContext() {
        return new InMemoryDbTransactionContext(this.database);
    }

    public boolean isEmpty(ColumnFamilyType column, TransactionContext context) {
        return this.createColumnFamily(column, context, DbNullKey.INSTANCE, DbNil.INSTANCE).isEmpty();
    }

    public StatefulMeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void close() {
        this.database.clear();
        MicrometerUtil.discard((CompositeMeterRegistry)this.meterRegistry);
    }
}

