/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

class GatewayRequestStore {
    private final Map<Long, Request> requestMap = new ConcurrentHashMap<Long, Request>();
    private final AtomicLong requestIdGenerator = new AtomicLong();

    GatewayRequestStore() {
    }

    Long registerNewRequest(Class<? extends GeneratedMessageV3> requestType, StreamObserver<?> responseObserver) {
        long currentRequestId = this.requestIdGenerator.incrementAndGet();
        this.requestMap.put(currentRequestId, new Request(requestType, responseObserver));
        return currentRequestId;
    }

    Request removeRequest(Long requestId) {
        return this.requestMap.remove(requestId);
    }

    record Request(Class<? extends GeneratedMessageV3> requestType, StreamObserver<?> responseObserver) {
    }
}

