/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.extension.testcontainer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerProperties {
    private static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe-process-test");
    private static final String PROPERTIES_FILE = "/config.properties";
    public static final String IMAGE_NAME = "container.image.name";
    public static final String IMAGE_TAG = "container.image.tag";
    public static final String GATEWAY_PORT = "container.gateway.port";
    public static final String PORT = "container.port";
    private static final Properties PROPERTIES = new Properties();

    public static String getDockerImageName() {
        return ContainerProperties.getProperty(IMAGE_NAME) + ":" + ContainerProperties.getProperty(IMAGE_TAG);
    }

    public static int getContainerPort() {
        return Integer.parseInt(ContainerProperties.getProperty(PORT));
    }

    public static int getGatewayPort() {
        return Integer.parseInt(ContainerProperties.getProperty(GATEWAY_PORT));
    }

    private static String getProperty(String property) {
        return PROPERTIES.getProperty(property);
    }

    static {
        try (InputStream inputStream = ContainerProperties.class.getResourceAsStream(PROPERTIES_FILE);){
            PROPERTIES.load(inputStream);
        }
        catch (FileNotFoundException e) {
            LOG.error("Could not find property file with name /config.properties", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            LOG.error("Could not read properties from file", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

