/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.process.test.assertions.ProcessAssert;
import io.camunda.zeebe.process.test.testengine.RecordStreamSource;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class DeploymentAssert
extends AbstractAssert<DeploymentAssert, DeploymentEvent> {
    private final RecordStreamSource recordStreamSource;

    public DeploymentAssert(DeploymentEvent actual, RecordStreamSource recordStreamSource) {
        super((Object)actual, DeploymentAssert.class);
        this.recordStreamSource = recordStreamSource;
    }

    public DeploymentAssert containsProcessesByBpmnProcessId(String ... expectedBpmnProcessIds) {
        Assertions.assertThat((Object[])expectedBpmnProcessIds).isNotEmpty();
        List deployedProcesses = ((DeploymentEvent)this.actual).getProcesses().stream().map(Process::getBpmnProcessId).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(deployedProcesses).describedAs("Deployed Processes (BPMN process IDs)", new Object[0])).contains((Object[])expectedBpmnProcessIds);
        return this;
    }

    public DeploymentAssert containsProcessesByResourceName(String ... expectedProcessInstanceResourceNames) {
        Assertions.assertThat((Object[])expectedProcessInstanceResourceNames).isNotEmpty();
        List deployedProcesses = ((DeploymentEvent)this.actual).getProcesses().stream().map(Process::getResourceName).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(deployedProcesses).describedAs("Deployed Processes (resource name)", new Object[0])).contains((Object[])expectedProcessInstanceResourceNames);
        return this;
    }

    public ProcessAssert extractingProcessByBpmnProcessId(String bpmnProcessId) {
        ((AbstractStringAssert)Assertions.assertThat((String)bpmnProcessId).describedAs("Parameter 'bpmnProcessId'", new Object[0])).isNotEmpty();
        List matchingProcesses = ((DeploymentEvent)this.actual).getProcesses().stream().filter(process -> process.getBpmnProcessId().equals(bpmnProcessId)).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(matchingProcesses).withFailMessage("Expected to find one process for BPMN process id '%s' but found %d: %s", new Object[]{bpmnProcessId, matchingProcesses.size(), matchingProcesses})).hasSize(1);
        return new ProcessAssert((Process)matchingProcesses.get(0), this.recordStreamSource);
    }

    public ProcessAssert extractingProcessByResourceName(String resourceName) {
        ((AbstractStringAssert)Assertions.assertThat((String)resourceName).describedAs("Parameter 'resourceName'", new Object[0])).isNotEmpty();
        List matchingProcesses = ((DeploymentEvent)this.actual).getProcesses().stream().filter(process -> process.getResourceName().equals(resourceName)).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(matchingProcesses).withFailMessage("Expected to find one process for resource name '%s' but found %d: %s", new Object[]{resourceName, matchingProcesses.size(), matchingProcesses})).hasSize(1);
        return new ProcessAssert((Process)matchingProcesses.get(0), this.recordStreamSource);
    }
}

