/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.extensions;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.process.test.RecordStreamSourceStore;
import io.camunda.zeebe.process.test.testengine.EngineFactory;
import io.camunda.zeebe.process.test.testengine.InMemoryEngine;
import io.camunda.zeebe.process.test.testengine.RecordStreamSource;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.commons.util.ReflectionUtils;

public class ZeebeProcessTestExtension
implements BeforeEachCallback,
AfterEachCallback,
TestWatcher {
    private static final String KEY_ZEEBE_CLIENT = "ZEEBE_CLIENT";
    private static final String KEY_ZEEBE_ENGINE = "ZEEBE_ENGINE";

    public void beforeEach(ExtensionContext extensionContext) {
        InMemoryEngine engine = EngineFactory.create();
        ZeebeClient client = engine.createClient();
        RecordStreamSource recordStream = engine.getRecordStream();
        this.injectFields(extensionContext, engine, client, recordStream);
        RecordStreamSourceStore.init(recordStream);
        this.getStore(extensionContext).put((Object)KEY_ZEEBE_CLIENT, (Object)client);
        this.getStore(extensionContext).put((Object)KEY_ZEEBE_ENGINE, (Object)engine);
        engine.start();
    }

    public void afterEach(ExtensionContext extensionContext) {
        RecordStreamSourceStore.reset();
        Object clientContent = this.getStore(extensionContext).get((Object)KEY_ZEEBE_CLIENT);
        ZeebeClient client = (ZeebeClient)clientContent;
        client.close();
        Object engineContent = this.getStore(extensionContext).get((Object)KEY_ZEEBE_ENGINE);
        InMemoryEngine engine = (InMemoryEngine)engineContent;
        engine.stop();
    }

    public void testFailed(ExtensionContext extensionContext, Throwable cause) {
        Object engineContent = this.getStore(extensionContext).get((Object)KEY_ZEEBE_ENGINE);
        InMemoryEngine engine = (InMemoryEngine)engineContent;
        System.out.println("===== Test failed! Printing records from the stream:");
        engine.getRecordStream().print(true);
    }

    private void injectFields(ExtensionContext extensionContext, Object ... objects) {
        Class requiredTestClass = extensionContext.getRequiredTestClass();
        Field[] declaredFields = requiredTestClass.getDeclaredFields();
        for (Object object : objects) {
            Optional<Field> field = this.getField(declaredFields, object);
            field.ifPresent(value -> this.injectField(extensionContext, (Field)value, object));
        }
    }

    private Optional<Field> getField(Field[] declaredFields, Object object) {
        List fields = Arrays.stream(declaredFields).filter(field -> field.getType().isInstance(object)).collect(Collectors.toList());
        if (fields.size() > 1) {
            throw new IllegalStateException(String.format("Expected at most one field of type %s, but found %s. Please make sure at most one field of type %s has been declared in the test class.", object.getClass().getSimpleName(), fields.size(), object.getClass().getSimpleName()));
        }
        return fields.size() == 0 ? Optional.empty() : Optional.of((Field)fields.get(0));
    }

    private void injectField(ExtensionContext extensionContext, Field field, Object object) {
        try {
            ReflectionUtils.makeAccessible((AccessibleObject)field);
            field.set(extensionContext.getRequiredTestInstance(), object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getUniqueId()}));
    }
}

