/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class VariableRecordStreamFilter {
    private Stream<Record<VariableRecordValue>> stream;

    public VariableRecordStreamFilter(Iterable<Record<VariableRecordValue>> records) {
        this.stream = StreamSupport.stream(records.spliterator(), false);
    }

    public VariableRecordStreamFilter(Stream<Record<VariableRecordValue>> stream) {
        this.stream = stream;
    }

    public VariableRecordStreamFilter withProcessInstanceKey(long processInstanceKey) {
        return new VariableRecordStreamFilter(this.stream.filter(record -> ((VariableRecordValue)record.getValue()).getProcessInstanceKey() == processInstanceKey));
    }

    public VariableRecordStreamFilter withRejectionType(RejectionType rejectionType) {
        return new VariableRecordStreamFilter(this.stream.filter(record -> record.getRejectionType() == rejectionType));
    }

    public Stream<Record<VariableRecordValue>> stream() {
        return this.stream;
    }
}

