/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.testengine;

import com.google.protobuf.GeneratedMessageV3;
import com.google.rpc.Status;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.process.test.testengine.GrpcToLogStreamGateway;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceResultRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class GrpcResponseWriter
implements CommandResponseWriter {
    final GrpcToLogStreamGateway gateway;
    private int partitionId = -1;
    private long key = -1L;
    private Intent intent = Intent.UNKNOWN;
    private RecordType recordType = RecordType.NULL_VAL;
    private ValueType valueType = ValueType.NULL_VAL;
    private RejectionType rejectionType = RejectionType.NULL_VAL;
    private String rejectionReason = "";
    private final DirectBuffer valueBufferView = new UnsafeBuffer();
    private final MutableDirectBuffer valueBuffer = new ExpandableArrayBuffer();
    private final Map<ValueType, Callable<GeneratedMessageV3>> responseMap = Map.of(ValueType.DEPLOYMENT, this::createDeployResponse, ValueType.PROCESS_INSTANCE_CREATION, this::createProcessInstanceResponse, ValueType.PROCESS_INSTANCE_RESULT, this::createProcessInstanceWithResultResponse, ValueType.PROCESS_INSTANCE, this::createCancelInstanceResponse, ValueType.INCIDENT, this::createResolveIncidentResponse, ValueType.VARIABLE_DOCUMENT, this::createSetVariablesResponse, ValueType.MESSAGE, this::createMessageResponse, ValueType.JOB_BATCH, this::createJobBatchResponse, ValueType.JOB, this::createJobResponse);

    public GrpcResponseWriter(GrpcToLogStreamGateway gateway) {
        this.gateway = gateway;
    }

    public CommandResponseWriter partitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public CommandResponseWriter key(long key) {
        this.key = key;
        return this;
    }

    public CommandResponseWriter intent(Intent intent) {
        this.intent = intent;
        return this;
    }

    public CommandResponseWriter recordType(RecordType type) {
        this.recordType = type;
        return this;
    }

    public CommandResponseWriter valueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public CommandResponseWriter rejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
        return this;
    }

    public CommandResponseWriter rejectionReason(DirectBuffer rejectionReason) {
        this.rejectionReason = BufferUtil.bufferAsString((DirectBuffer)rejectionReason);
        return this;
    }

    public CommandResponseWriter valueWriter(BufferWriter value) {
        value.write(this.valueBuffer, 0);
        this.valueBufferView.wrap((DirectBuffer)this.valueBuffer, 0, value.getLength());
        return this;
    }

    public boolean tryWriteResponse(int requestStreamId, long requestId) {
        if (this.rejectionType != RejectionType.NULL_VAL) {
            Status rejectionResponse = this.createRejectionResponse();
            this.gateway.errorCallback(requestId, rejectionResponse);
            return true;
        }
        try {
            GeneratedMessageV3 response = this.responseMap.get(this.valueType).call();
            this.gateway.responseCallback(requestId, response);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private GatewayOuterClass.DeployProcessResponse createDeployResponse() {
        DeploymentRecord deployment = new DeploymentRecord();
        deployment.wrap(this.valueBufferView);
        return GatewayOuterClass.DeployProcessResponse.newBuilder().setKey(this.key).addAllProcesses((Iterable)deployment.getProcessesMetadata().stream().map(metadata -> GatewayOuterClass.ProcessMetadata.newBuilder().setProcessDefinitionKey(metadata.getProcessDefinitionKey()).setBpmnProcessId(metadata.getBpmnProcessId()).setVersion(metadata.getVersion()).setResourceName(metadata.getResourceName()).build()).collect(Collectors.toList())).build();
    }

    private GeneratedMessageV3 createProcessInstanceResponse() {
        ProcessInstanceCreationRecord processInstance = new ProcessInstanceCreationRecord();
        processInstance.wrap(this.valueBufferView);
        return GatewayOuterClass.CreateProcessInstanceResponse.newBuilder().setProcessInstanceKey(processInstance.getProcessInstanceKey()).setProcessDefinitionKey(processInstance.getProcessDefinitionKey()).setBpmnProcessId(processInstance.getBpmnProcessId()).setVersion(processInstance.getVersion()).build();
    }

    private GeneratedMessageV3 createProcessInstanceWithResultResponse() {
        ProcessInstanceResultRecord processInstanceResult = new ProcessInstanceResultRecord();
        processInstanceResult.wrap(this.valueBufferView);
        return GatewayOuterClass.CreateProcessInstanceWithResultResponse.newBuilder().setProcessInstanceKey(processInstanceResult.getProcessInstanceKey()).setProcessDefinitionKey(processInstanceResult.getProcessDefinitionKey()).setBpmnProcessId(processInstanceResult.getBpmnProcessId()).setVersion(processInstanceResult.getVersion()).setVariables(MsgPackConverter.convertToJson((DirectBuffer)processInstanceResult.getVariablesBuffer())).build();
    }

    private GeneratedMessageV3 createCancelInstanceResponse() {
        return GatewayOuterClass.CancelProcessInstanceResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createResolveIncidentResponse() {
        IncidentRecord incident = new IncidentRecord();
        incident.wrap(this.valueBufferView);
        return GatewayOuterClass.ResolveIncidentResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createSetVariablesResponse() {
        VariableDocumentRecord variableDocumentRecord = new VariableDocumentRecord();
        variableDocumentRecord.wrap(this.valueBufferView);
        return GatewayOuterClass.SetVariablesResponse.newBuilder().setKey(this.key).build();
    }

    private GeneratedMessageV3 createMessageResponse() {
        return GatewayOuterClass.PublishMessageResponse.newBuilder().setKey(this.key).build();
    }

    private GeneratedMessageV3 createJobBatchResponse() {
        JobBatchRecord jobBatch = new JobBatchRecord();
        jobBatch.wrap(this.valueBufferView);
        HashMap<Long, JobRecord> jobsWithKeys = new HashMap<Long, JobRecord>();
        for (int index = 0; index < jobBatch.getJobKeys().size(); ++index) {
            Long key = (Long)jobBatch.getJobKeys().get(index);
            JobRecord value = (JobRecord)jobBatch.getJobs().get(index);
            jobsWithKeys.put(key, value);
        }
        return GatewayOuterClass.ActivateJobsResponse.newBuilder().addAllJobs((Iterable)jobsWithKeys.entrySet().stream().map(entry -> {
            JobRecord job = (JobRecord)entry.getValue();
            return GatewayOuterClass.ActivatedJob.newBuilder().setKey(((Long)entry.getKey()).longValue()).setType(job.getType()).setRetries(job.getRetries()).setWorker(job.getWorker()).setDeadline(job.getDeadline()).setProcessDefinitionKey(job.getProcessDefinitionKey()).setBpmnProcessId(job.getBpmnProcessId()).setProcessDefinitionVersion(job.getProcessDefinitionVersion()).setProcessInstanceKey(job.getProcessInstanceKey()).setElementId(job.getElementId()).setElementInstanceKey(job.getElementInstanceKey()).setCustomHeaders(MsgPackConverter.convertToJson((DirectBuffer)job.getCustomHeadersBuffer())).setVariables(MsgPackConverter.convertToJson((DirectBuffer)job.getVariablesBuffer())).build();
        }).collect(Collectors.toList())).build();
    }

    private GeneratedMessageV3 createCompleteJobResponse() {
        return GatewayOuterClass.CompleteJobResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createFailJobResponse() {
        return GatewayOuterClass.FailJobResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createJobThrowErrorResponse() {
        return GatewayOuterClass.ThrowErrorResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createJobUpdateRetriesResponse() {
        return GatewayOuterClass.UpdateJobRetriesResponse.newBuilder().build();
    }

    private GeneratedMessageV3 createJobResponse() {
        switch ((JobIntent)this.intent) {
            case COMPLETED: {
                return this.createCompleteJobResponse();
            }
            case FAILED: {
                return this.createFailJobResponse();
            }
            case ERROR_THROWN: {
                return this.createJobThrowErrorResponse();
            }
            case RETRIES_UPDATED: {
                return this.createJobUpdateRetriesResponse();
            }
        }
        throw new UnsupportedOperationException(String.format("Job command '%s' is not supported", this.intent));
    }

    private Status createRejectionResponse() {
        int statusCode;
        switch (this.rejectionType) {
            case INVALID_ARGUMENT: {
                statusCode = 3;
                break;
            }
            case NOT_FOUND: {
                statusCode = 5;
                break;
            }
            case ALREADY_EXISTS: {
                statusCode = 6;
                break;
            }
            case INVALID_STATE: {
                statusCode = 9;
                break;
            }
            case PROCESSING_ERROR: {
                statusCode = 13;
                break;
            }
            default: {
                statusCode = 2;
            }
        }
        return Status.newBuilder().setMessage(String.format("Command '%s' rejected with code '%s': %s", this.intent, this.rejectionType, this.rejectionReason)).setCode(statusCode).build();
    }
}

