/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.testengine;

import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorListener;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.process.test.testengine.InMemoryLogStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

final class IdleStateMonitor
implements LogStorage.CommitListener,
StreamProcessorListener {
    private static final Timer TIMER = new Timer();
    public static final int GRACE_PERIOD = 10;
    private final List<Runnable> callbacks = new ArrayList<Runnable>();
    private final LogStreamReader reader;
    private volatile long lastEventPosition = -1L;
    private volatile long lastProcessedPosition = -1L;
    private volatile TimerTask idleStateNotifier = this.createIdleStateNotifier();

    IdleStateMonitor(InMemoryLogStorage logStorage, LogStreamReader logStreamReader) {
        logStorage.addCommitListener(this);
        this.reader = logStreamReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(Runnable callback) {
        List<Runnable> list = this.callbacks;
        synchronized (list) {
            this.callbacks.add(callback);
        }
        this.checkIdleState();
    }

    private void checkIdleState() {
        if (this.isInIdleState()) {
            this.scheduleNotification();
        } else {
            this.cancelNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNotification() {
        TimerTask timerTask = this.idleStateNotifier;
        synchronized (timerTask) {
            this.idleStateNotifier = this.createIdleStateNotifier();
            try {
                TIMER.schedule(this.idleStateNotifier, 10L);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelNotification() {
        TimerTask timerTask = this.idleStateNotifier;
        synchronized (timerTask) {
            this.idleStateNotifier.cancel();
        }
    }

    private boolean isInIdleState() {
        this.forwardToLastEvent();
        return this.lastEventPosition == this.lastProcessedPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardToLastEvent() {
        LogStreamReader logStreamReader = this.reader;
        synchronized (logStreamReader) {
            while (this.reader.hasNext()) {
                this.lastEventPosition = ((LoggedEvent)this.reader.next()).getPosition();
            }
        }
    }

    public void onCommit() {
        this.checkIdleState();
    }

    public void onProcessed(TypedRecord<?> processedCommand) {
        this.lastProcessedPosition = Math.max(this.lastProcessedPosition, processedCommand.getPosition());
        this.checkIdleState();
    }

    public void onSkipped(LoggedEvent skippedRecord) {
        this.lastProcessedPosition = Math.max(this.lastProcessedPosition, skippedRecord.getPosition());
        this.checkIdleState();
    }

    public void onReplayed(long lastReplayedEventPosition, long lastReadRecordPosition) {
        this.lastProcessedPosition = Math.max(this.lastProcessedPosition, lastReplayedEventPosition);
        this.checkIdleState();
    }

    private TimerTask createIdleStateNotifier() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (IdleStateMonitor.this.isInIdleState()) {
                    List<Runnable> list = IdleStateMonitor.this.callbacks;
                    synchronized (list) {
                        IdleStateMonitor.this.callbacks.forEach(Runnable::run);
                        IdleStateMonitor.this.callbacks.clear();
                    }
                }
            }
        };
    }
}

