/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.testengine;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.process.test.testengine.GrpcToLogStreamGateway;
import io.camunda.zeebe.process.test.testengine.IdleStateMonitor;
import io.camunda.zeebe.process.test.testengine.InMemoryEngine;
import io.camunda.zeebe.process.test.testengine.RecordStreamSource;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.clock.ControlledActorClock;
import io.grpc.Server;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class InMemoryEngineImpl
implements InMemoryEngine {
    private final Server grpcServer;
    private final StreamProcessor streamProcessor;
    private final GrpcToLogStreamGateway gateway;
    private final ZeebeDb<ZbColumnFamilies> database;
    private final LogStream logStream;
    private final ActorScheduler scheduler;
    private final RecordStreamSource recordStream;
    private final ControlledActorClock clock;
    private final IdleStateMonitor idleStateMonitor;

    public InMemoryEngineImpl(Server grpcServer, StreamProcessor streamProcessor, GrpcToLogStreamGateway gateway, ZeebeDb<ZbColumnFamilies> database, LogStream logStream, ActorScheduler scheduler, RecordStreamSource recordStream, ControlledActorClock clock, IdleStateMonitor idleStateMonitor) {
        this.grpcServer = grpcServer;
        this.streamProcessor = streamProcessor;
        this.gateway = gateway;
        this.database = database;
        this.logStream = logStream;
        this.scheduler = scheduler;
        this.recordStream = recordStream;
        this.clock = clock;
        this.idleStateMonitor = idleStateMonitor;
    }

    @Override
    public void start() {
        try {
            this.grpcServer.start();
            this.streamProcessor.openAsync(false).join();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try {
            this.grpcServer.shutdownNow();
            this.grpcServer.awaitTermination();
            this.gateway.close();
            this.streamProcessor.close();
            this.database.close();
            this.logStream.close();
            this.scheduler.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RecordStreamSource getRecordStream() {
        return this.recordStream;
    }

    @Override
    public ZeebeClient createClient() {
        return ZeebeClient.newClientBuilder().gatewayAddress(this.getGatewayAddress()).usePlaintext().build();
    }

    @Override
    public String getGatewayAddress() {
        return this.gateway.getAddress();
    }

    @Override
    public void increaseTime(Duration timeToAdd) {
        this.clock.addTime(timeToAdd);
    }

    @Override
    public void runOnIdleState(Runnable callback) {
        this.idleStateMonitor.addCallback(callback);
    }

    @Override
    public void waitForIdleState() {
        CompletableFuture idleState = new CompletableFuture();
        this.runOnIdleState(() -> idleState.complete(null));
        idleState.join();
    }
}

