/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.testengine;

import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.storage.LogStorageReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class InMemoryLogStorage
implements LogStorage {
    private final ConcurrentSkipListMap<Long, Integer> positionIndexMapping = new ConcurrentSkipListMap();
    private final List<ByteBuffer> logEntries = new ArrayList<ByteBuffer>();
    private final Set<LogStorage.CommitListener> commitListeners = new HashSet<LogStorage.CommitListener>();

    public LogStorageReader newReader() {
        return new ListLogStorageReader();
    }

    public void addCommitListener(LogStorage.CommitListener listener) {
        this.commitListeners.add(listener);
    }

    public void removeCommitListener(LogStorage.CommitListener listener) {
        this.commitListeners.remove(listener);
    }

    public void append(long lowestPosition, long highestPosition, ByteBuffer blockBuffer, LogStorage.AppendListener listener) {
        try {
            this.logEntries.add(blockBuffer);
            int index = this.logEntries.size();
            this.positionIndexMapping.put(lowestPosition, index);
            listener.onWrite((long)index);
            listener.onCommit((long)index);
            this.commitListeners.forEach(LogStorage.CommitListener::onCommit);
        }
        catch (Exception e) {
            listener.onWriteError((Throwable)e);
        }
    }

    private class ListLogStorageReader
    implements LogStorageReader {
        private int currentIndex = 0;

        private ListLogStorageReader() {
        }

        public void seek(long position) {
            this.currentIndex = Optional.ofNullable(InMemoryLogStorage.this.positionIndexMapping.lowerEntry(position)).map(Map.Entry::getValue).map(index -> index - 1).orElse(0);
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.currentIndex >= 0 && this.currentIndex < InMemoryLogStorage.this.logEntries.size();
        }

        public DirectBuffer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.currentIndex++;
            return new UnsafeBuffer(InMemoryLogStorage.this.logEntries.get(index));
        }
    }
}

