/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.testengine;

import io.camunda.zeebe.engine.processing.message.command.PartitionCommandSender;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandMessageHandler;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class PartitionCommandSenderImpl
implements PartitionCommandSender {
    private final SubscriptionCommandMessageHandler subscriptionHandler;
    private final int partitionId;

    public PartitionCommandSenderImpl(SubscriptionCommandMessageHandler subscriptionHandler, int partitionId) {
        this.subscriptionHandler = subscriptionHandler;
        this.partitionId = partitionId;
    }

    public boolean sendCommand(int receiverPartitionId, BufferWriter command) {
        if (receiverPartitionId != this.partitionId) {
            throw new RuntimeException(String.format("Expected receiverPartitionId to be %d, but was %d", this.partitionId, receiverPartitionId));
        }
        byte[] bytes = new byte[command.getLength()];
        UnsafeBuffer commandBuffer = new UnsafeBuffer(bytes);
        command.write((MutableDirectBuffer)commandBuffer, 0);
        this.subscriptionHandler.apply(bytes);
        return true;
    }
}

