/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.testengine;

import io.camunda.zeebe.engine.processing.message.command.PartitionCommandSender;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandMessageHandler;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.process.test.testengine.PartitionCommandSenderImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SubscriptionCommandSenderFactory {
    final LogStreamRecordWriter streamWriter;
    private final ExecutorService subscriptionHandlerExecutor = Executors.newSingleThreadExecutor();
    private final int partitionId;

    public SubscriptionCommandSenderFactory(LogStreamRecordWriter streamWriter, int partitionId) {
        this.streamWriter = streamWriter;
        this.partitionId = partitionId;
    }

    public SubscriptionCommandSender createSender() {
        SubscriptionCommandMessageHandler handler = new SubscriptionCommandMessageHandler(this.subscriptionHandlerExecutor::submit, this::getStreamWriter);
        return new SubscriptionCommandSender(this.partitionId, (PartitionCommandSender)new PartitionCommandSenderImpl(handler, this.partitionId));
    }

    private LogStreamRecordWriter getStreamWriter(int receivedPartitionId) {
        if (receivedPartitionId != this.partitionId) {
            throw new RuntimeException(String.format("Expected receivedPartitionId to be %d, but was %d", this.partitionId, receivedPartitionId));
        }
        return this.streamWriter;
    }
}

