/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.testengine.db;

import io.camunda.zeebe.db.DbValue;
import java.util.Arrays;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

final class Bytes
implements Comparable<Bytes> {
    private final byte[] byteArray;

    private Bytes(byte[] byteArray) {
        this.byteArray = byteArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bytes bytes = (Bytes)o;
        return Arrays.equals(this.byteArray, bytes.byteArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.byteArray);
    }

    @Override
    public int compareTo(Bytes other) {
        boolean EQUAL = false;
        int SMALLER = -1;
        boolean BIGGER = true;
        byte[] otherByteArray = other.byteArray;
        for (int i = 0; i < this.byteArray.length; ++i) {
            if (i >= otherByteArray.length) {
                return 1;
            }
            byte ourByte = this.byteArray[i];
            byte otherByte = otherByteArray[i];
            if (ourByte < otherByte) {
                return -1;
            }
            if (ourByte <= otherByte) continue;
            return 1;
        }
        if (this.byteArray.length == otherByteArray.length) {
            return 0;
        }
        return -1;
    }

    byte[] toBytes() {
        return this.byteArray;
    }

    static Bytes fromByteArray(byte[] array, int length) {
        return new Bytes(Arrays.copyOfRange(array, 0, length));
    }

    static Bytes fromByteArray(byte[] array) {
        return new Bytes(Arrays.copyOf(array, array.length));
    }

    static Bytes fromExpandableArrayBuffer(ExpandableArrayBuffer buffer) {
        return Bytes.fromByteArray(buffer.byteArray());
    }

    static Bytes fromDbValue(DbValue value) {
        ExpandableArrayBuffer valueBuffer = new ExpandableArrayBuffer(0);
        value.write((MutableDirectBuffer)valueBuffer, 0);
        return Bytes.fromExpandableArrayBuffer(valueBuffer);
    }

    public static Bytes empty() {
        return new Bytes(new byte[0]);
    }
}

