/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.testengine.db;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.process.test.testengine.db.Bytes;
import io.camunda.zeebe.process.test.testengine.db.DbNullKey;
import io.camunda.zeebe.process.test.testengine.db.InMemoryDbColumnFamily;
import io.camunda.zeebe.process.test.testengine.db.InMemoryDbTransactionContext;
import java.io.File;
import java.util.Optional;
import java.util.TreeMap;

final class InMemoryDb<ColumnFamilyType extends Enum<ColumnFamilyType>>
implements ZeebeDb<ColumnFamilyType> {
    private final TreeMap<Bytes, Bytes> database = new TreeMap();

    InMemoryDb() {
    }

    public <KeyType extends DbKey, ValueType extends DbValue> ColumnFamily<KeyType, ValueType> createColumnFamily(ColumnFamilyType columnFamily, TransactionContext context, KeyType keyInstance, ValueType valueInstance) {
        return new InMemoryDbColumnFamily<ColumnFamilyType, KeyType, ValueType>(columnFamily, context, keyInstance, valueInstance);
    }

    public void createSnapshot(File snapshotDir) {
        throw new IllegalStateException("No snapshots supported");
    }

    public Optional<String> getProperty(String propertyName) {
        return Optional.empty();
    }

    public TransactionContext createContext() {
        return new InMemoryDbTransactionContext(this.database);
    }

    public boolean isEmpty(ColumnFamilyType column, TransactionContext context) {
        return this.createColumnFamily(column, context, DbNullKey.INSTANCE, DbNil.INSTANCE).isEmpty();
    }

    public void close() {
        this.database.clear();
    }
}

