/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class RecordAssert
extends AbstractObjectAssert<RecordAssert, Record> {
    public RecordAssert(Record actual) {
        super((Object)actual, RecordAssert.class);
    }

    @CheckReturnValue
    public static RecordAssert assertThat(Record actual) {
        return new RecordAssert(actual);
    }

    public RecordAssert hasAuthorizations(Map authorizations) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting authorizations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualAuthorizations = ((Record)this.actual).getAuthorizations();
        if (!Objects.areEqual((Object)actualAuthorizations, (Object)authorizations)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, authorizations, actualAuthorizations});
        }
        return this;
    }

    public RecordAssert hasBrokerVersion(String brokerVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting brokerVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualBrokerVersion = ((Record)this.actual).getBrokerVersion();
        if (!Objects.areEqual((Object)actualBrokerVersion, (Object)brokerVersion)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, brokerVersion, actualBrokerVersion});
        }
        return this;
    }

    public RecordAssert hasIntent(Intent intent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting intent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Intent actualIntent = ((Record)this.actual).getIntent();
        if (!Objects.areEqual((Object)actualIntent, (Object)intent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, intent, actualIntent});
        }
        return this;
    }

    public RecordAssert hasKey(long key) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting key of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualKey = ((Record)this.actual).getKey();
        if (actualKey != key) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, key, actualKey});
        }
        return this;
    }

    public RecordAssert hasPartitionId(int partitionId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting partitionId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualPartitionId = ((Record)this.actual).getPartitionId();
        if (actualPartitionId != partitionId) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, partitionId, actualPartitionId});
        }
        return this;
    }

    public RecordAssert hasPosition(long position) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting position of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualPosition = ((Record)this.actual).getPosition();
        if (actualPosition != position) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, position, actualPosition});
        }
        return this;
    }

    public RecordAssert hasRecordType(RecordType recordType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting recordType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RecordType actualRecordType = ((Record)this.actual).getRecordType();
        if (!Objects.areEqual((Object)actualRecordType, (Object)recordType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, recordType, actualRecordType});
        }
        return this;
    }

    public RecordAssert hasRecordVersion(int recordVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting recordVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualRecordVersion = ((Record)this.actual).getRecordVersion();
        if (actualRecordVersion != recordVersion) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, recordVersion, actualRecordVersion});
        }
        return this;
    }

    public RecordAssert hasRejectionReason(String rejectionReason) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting rejectionReason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualRejectionReason = ((Record)this.actual).getRejectionReason();
        if (!Objects.areEqual((Object)actualRejectionReason, (Object)rejectionReason)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, rejectionReason, actualRejectionReason});
        }
        return this;
    }

    public RecordAssert hasRejectionType(RejectionType rejectionType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting rejectionType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RejectionType actualRejectionType = ((Record)this.actual).getRejectionType();
        if (!Objects.areEqual((Object)actualRejectionType, (Object)rejectionType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, rejectionType, actualRejectionType});
        }
        return this;
    }

    public RecordAssert hasSourceRecordPosition(long sourceRecordPosition) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sourceRecordPosition of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualSourceRecordPosition = ((Record)this.actual).getSourceRecordPosition();
        if (actualSourceRecordPosition != sourceRecordPosition) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sourceRecordPosition, actualSourceRecordPosition});
        }
        return this;
    }

    public RecordAssert hasTimestamp(long timestamp) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting timestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualTimestamp = ((Record)this.actual).getTimestamp();
        if (actualTimestamp != timestamp) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, timestamp, actualTimestamp});
        }
        return this;
    }

    public RecordAssert hasValue(RecordValue value) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RecordValue actualValue = ((Record)this.actual).getValue();
        if (!Objects.areEqual((Object)actualValue, (Object)value)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, value, actualValue});
        }
        return this;
    }

    public RecordAssert hasValueType(ValueType valueType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting valueType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ValueType actualValueType = ((Record)this.actual).getValueType();
        if (!Objects.areEqual((Object)actualValueType, (Object)valueType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, valueType, actualValueType});
        }
        return this;
    }
}

