/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class DecisionEvaluationRecordValueAssert
extends AbstractObjectAssert<DecisionEvaluationRecordValueAssert, DecisionEvaluationRecordValue> {
    public DecisionEvaluationRecordValueAssert(DecisionEvaluationRecordValue actual) {
        super((Object)actual, DecisionEvaluationRecordValueAssert.class);
    }

    @CheckReturnValue
    public static DecisionEvaluationRecordValueAssert assertThat(DecisionEvaluationRecordValue actual) {
        return new DecisionEvaluationRecordValueAssert(actual);
    }

    public DecisionEvaluationRecordValueAssert hasBpmnProcessId(String bpmnProcessId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualBpmnProcessId = ((DecisionEvaluationRecordValue)this.actual).getBpmnProcessId();
        if (!Objects.areEqual((Object)actualBpmnProcessId, (Object)bpmnProcessId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, bpmnProcessId, actualBpmnProcessId});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasDecisionId(String decisionId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionId = ((DecisionEvaluationRecordValue)this.actual).getDecisionId();
        if (!Objects.areEqual((Object)actualDecisionId, (Object)decisionId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionId, actualDecisionId});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasDecisionKey(long decisionKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualDecisionKey = ((DecisionEvaluationRecordValue)this.actual).getDecisionKey();
        if (actualDecisionKey != decisionKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionKey, actualDecisionKey});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasDecisionName(String decisionName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionName = ((DecisionEvaluationRecordValue)this.actual).getDecisionName();
        if (!Objects.areEqual((Object)actualDecisionName, (Object)decisionName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionName, actualDecisionName});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasDecisionOutput(String decisionOutput) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionOutput of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionOutput = ((DecisionEvaluationRecordValue)this.actual).getDecisionOutput();
        if (!Objects.areEqual((Object)actualDecisionOutput, (Object)decisionOutput)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionOutput, actualDecisionOutput});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasDecisionRequirementsId(String decisionRequirementsId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionRequirementsId = ((DecisionEvaluationRecordValue)this.actual).getDecisionRequirementsId();
        if (!Objects.areEqual((Object)actualDecisionRequirementsId, (Object)decisionRequirementsId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsId, actualDecisionRequirementsId});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasDecisionRequirementsKey(long decisionRequirementsKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualDecisionRequirementsKey = ((DecisionEvaluationRecordValue)this.actual).getDecisionRequirementsKey();
        if (actualDecisionRequirementsKey != decisionRequirementsKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsKey, actualDecisionRequirementsKey});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasDecisionVersion(int decisionVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualDecisionVersion = ((DecisionEvaluationRecordValue)this.actual).getDecisionVersion();
        if (actualDecisionVersion != decisionVersion) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionVersion, actualDecisionVersion});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasElementId(String elementId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting elementId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualElementId = ((DecisionEvaluationRecordValue)this.actual).getElementId();
        if (!Objects.areEqual((Object)actualElementId, (Object)elementId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, elementId, actualElementId});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasElementInstanceKey(long elementInstanceKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting elementInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualElementInstanceKey = ((DecisionEvaluationRecordValue)this.actual).getElementInstanceKey();
        if (actualElementInstanceKey != elementInstanceKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, elementInstanceKey, actualElementInstanceKey});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasEvaluatedDecisions(EvaluatedDecisionValue ... evaluatedDecisions) {
        this.isNotNull();
        if (evaluatedDecisions == null) {
            this.failWithMessage("Expecting evaluatedDecisions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((DecisionEvaluationRecordValue)this.actual).getEvaluatedDecisions(), (Object[])evaluatedDecisions);
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasEvaluatedDecisions(Collection<? extends EvaluatedDecisionValue> evaluatedDecisions) {
        this.isNotNull();
        if (evaluatedDecisions == null) {
            this.failWithMessage("Expecting evaluatedDecisions parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((DecisionEvaluationRecordValue)this.actual).getEvaluatedDecisions(), evaluatedDecisions.toArray());
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasOnlyEvaluatedDecisions(EvaluatedDecisionValue ... evaluatedDecisions) {
        this.isNotNull();
        if (evaluatedDecisions == null) {
            this.failWithMessage("Expecting evaluatedDecisions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((DecisionEvaluationRecordValue)this.actual).getEvaluatedDecisions(), (Object[])evaluatedDecisions);
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasOnlyEvaluatedDecisions(Collection<? extends EvaluatedDecisionValue> evaluatedDecisions) {
        this.isNotNull();
        if (evaluatedDecisions == null) {
            this.failWithMessage("Expecting evaluatedDecisions parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((DecisionEvaluationRecordValue)this.actual).getEvaluatedDecisions(), evaluatedDecisions.toArray());
        return this;
    }

    public DecisionEvaluationRecordValueAssert doesNotHaveEvaluatedDecisions(EvaluatedDecisionValue ... evaluatedDecisions) {
        this.isNotNull();
        if (evaluatedDecisions == null) {
            this.failWithMessage("Expecting evaluatedDecisions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((DecisionEvaluationRecordValue)this.actual).getEvaluatedDecisions(), (Object[])evaluatedDecisions);
        return this;
    }

    public DecisionEvaluationRecordValueAssert doesNotHaveEvaluatedDecisions(Collection<? extends EvaluatedDecisionValue> evaluatedDecisions) {
        this.isNotNull();
        if (evaluatedDecisions == null) {
            this.failWithMessage("Expecting evaluatedDecisions parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((DecisionEvaluationRecordValue)this.actual).getEvaluatedDecisions(), evaluatedDecisions.toArray());
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasNoEvaluatedDecisions() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have evaluatedDecisions but had :\n  <%s>";
        if (((DecisionEvaluationRecordValue)this.actual).getEvaluatedDecisions().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((DecisionEvaluationRecordValue)this.actual).getEvaluatedDecisions()});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasEvaluationFailureMessage(String evaluationFailureMessage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting evaluationFailureMessage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualEvaluationFailureMessage = ((DecisionEvaluationRecordValue)this.actual).getEvaluationFailureMessage();
        if (!Objects.areEqual((Object)actualEvaluationFailureMessage, (Object)evaluationFailureMessage)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, evaluationFailureMessage, actualEvaluationFailureMessage});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasFailedDecisionId(String failedDecisionId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting failedDecisionId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFailedDecisionId = ((DecisionEvaluationRecordValue)this.actual).getFailedDecisionId();
        if (!Objects.areEqual((Object)actualFailedDecisionId, (Object)failedDecisionId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, failedDecisionId, actualFailedDecisionId});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasProcessDefinitionKey(long processDefinitionKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualProcessDefinitionKey = ((DecisionEvaluationRecordValue)this.actual).getProcessDefinitionKey();
        if (actualProcessDefinitionKey != processDefinitionKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, processDefinitionKey, actualProcessDefinitionKey});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasProcessInstanceKey(long processInstanceKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualProcessInstanceKey = ((DecisionEvaluationRecordValue)this.actual).getProcessInstanceKey();
        if (actualProcessInstanceKey != processInstanceKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, processInstanceKey, actualProcessInstanceKey});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((DecisionEvaluationRecordValue)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }

    public DecisionEvaluationRecordValueAssert hasVariables(Map variables) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting variables of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualVariables = ((DecisionEvaluationRecordValue)this.actual).getVariables();
        if (!Objects.areEqual((Object)actualVariables, (Object)variables)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, variables, actualVariables});
        }
        return this;
    }
}

