/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedInputValue;
import io.camunda.zeebe.protocol.record.value.MatchedRuleValue;
import java.util.Collection;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class EvaluatedDecisionValueAssert
extends AbstractObjectAssert<EvaluatedDecisionValueAssert, EvaluatedDecisionValue> {
    public EvaluatedDecisionValueAssert(EvaluatedDecisionValue actual) {
        super((Object)actual, EvaluatedDecisionValueAssert.class);
    }

    @CheckReturnValue
    public static EvaluatedDecisionValueAssert assertThat(EvaluatedDecisionValue actual) {
        return new EvaluatedDecisionValueAssert(actual);
    }

    public EvaluatedDecisionValueAssert hasDecisionId(String decisionId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionId = ((EvaluatedDecisionValue)this.actual).getDecisionId();
        if (!Objects.areEqual((Object)actualDecisionId, (Object)decisionId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionId, actualDecisionId});
        }
        return this;
    }

    public EvaluatedDecisionValueAssert hasDecisionKey(long decisionKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualDecisionKey = ((EvaluatedDecisionValue)this.actual).getDecisionKey();
        if (actualDecisionKey != decisionKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionKey, actualDecisionKey});
        }
        return this;
    }

    public EvaluatedDecisionValueAssert hasDecisionName(String decisionName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionName = ((EvaluatedDecisionValue)this.actual).getDecisionName();
        if (!Objects.areEqual((Object)actualDecisionName, (Object)decisionName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionName, actualDecisionName});
        }
        return this;
    }

    public EvaluatedDecisionValueAssert hasDecisionOutput(String decisionOutput) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionOutput of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionOutput = ((EvaluatedDecisionValue)this.actual).getDecisionOutput();
        if (!Objects.areEqual((Object)actualDecisionOutput, (Object)decisionOutput)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionOutput, actualDecisionOutput});
        }
        return this;
    }

    public EvaluatedDecisionValueAssert hasDecisionType(String decisionType) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionType = ((EvaluatedDecisionValue)this.actual).getDecisionType();
        if (!Objects.areEqual((Object)actualDecisionType, (Object)decisionType)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionType, actualDecisionType});
        }
        return this;
    }

    public EvaluatedDecisionValueAssert hasDecisionVersion(int decisionVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualDecisionVersion = ((EvaluatedDecisionValue)this.actual).getDecisionVersion();
        if (actualDecisionVersion != decisionVersion) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionVersion, actualDecisionVersion});
        }
        return this;
    }

    public EvaluatedDecisionValueAssert hasEvaluatedInputs(EvaluatedInputValue ... evaluatedInputs) {
        this.isNotNull();
        if (evaluatedInputs == null) {
            this.failWithMessage("Expecting evaluatedInputs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getEvaluatedInputs(), (Object[])evaluatedInputs);
        return this;
    }

    public EvaluatedDecisionValueAssert hasEvaluatedInputs(Collection<? extends EvaluatedInputValue> evaluatedInputs) {
        this.isNotNull();
        if (evaluatedInputs == null) {
            this.failWithMessage("Expecting evaluatedInputs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getEvaluatedInputs(), evaluatedInputs.toArray());
        return this;
    }

    public EvaluatedDecisionValueAssert hasOnlyEvaluatedInputs(EvaluatedInputValue ... evaluatedInputs) {
        this.isNotNull();
        if (evaluatedInputs == null) {
            this.failWithMessage("Expecting evaluatedInputs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getEvaluatedInputs(), (Object[])evaluatedInputs);
        return this;
    }

    public EvaluatedDecisionValueAssert hasOnlyEvaluatedInputs(Collection<? extends EvaluatedInputValue> evaluatedInputs) {
        this.isNotNull();
        if (evaluatedInputs == null) {
            this.failWithMessage("Expecting evaluatedInputs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getEvaluatedInputs(), evaluatedInputs.toArray());
        return this;
    }

    public EvaluatedDecisionValueAssert doesNotHaveEvaluatedInputs(EvaluatedInputValue ... evaluatedInputs) {
        this.isNotNull();
        if (evaluatedInputs == null) {
            this.failWithMessage("Expecting evaluatedInputs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getEvaluatedInputs(), (Object[])evaluatedInputs);
        return this;
    }

    public EvaluatedDecisionValueAssert doesNotHaveEvaluatedInputs(Collection<? extends EvaluatedInputValue> evaluatedInputs) {
        this.isNotNull();
        if (evaluatedInputs == null) {
            this.failWithMessage("Expecting evaluatedInputs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getEvaluatedInputs(), evaluatedInputs.toArray());
        return this;
    }

    public EvaluatedDecisionValueAssert hasNoEvaluatedInputs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have evaluatedInputs but had :\n  <%s>";
        if (((EvaluatedDecisionValue)this.actual).getEvaluatedInputs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((EvaluatedDecisionValue)this.actual).getEvaluatedInputs()});
        }
        return this;
    }

    public EvaluatedDecisionValueAssert hasMatchedRules(MatchedRuleValue ... matchedRules) {
        this.isNotNull();
        if (matchedRules == null) {
            this.failWithMessage("Expecting matchedRules parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getMatchedRules(), (Object[])matchedRules);
        return this;
    }

    public EvaluatedDecisionValueAssert hasMatchedRules(Collection<? extends MatchedRuleValue> matchedRules) {
        this.isNotNull();
        if (matchedRules == null) {
            this.failWithMessage("Expecting matchedRules parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getMatchedRules(), matchedRules.toArray());
        return this;
    }

    public EvaluatedDecisionValueAssert hasOnlyMatchedRules(MatchedRuleValue ... matchedRules) {
        this.isNotNull();
        if (matchedRules == null) {
            this.failWithMessage("Expecting matchedRules parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getMatchedRules(), (Object[])matchedRules);
        return this;
    }

    public EvaluatedDecisionValueAssert hasOnlyMatchedRules(Collection<? extends MatchedRuleValue> matchedRules) {
        this.isNotNull();
        if (matchedRules == null) {
            this.failWithMessage("Expecting matchedRules parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getMatchedRules(), matchedRules.toArray());
        return this;
    }

    public EvaluatedDecisionValueAssert doesNotHaveMatchedRules(MatchedRuleValue ... matchedRules) {
        this.isNotNull();
        if (matchedRules == null) {
            this.failWithMessage("Expecting matchedRules parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getMatchedRules(), (Object[])matchedRules);
        return this;
    }

    public EvaluatedDecisionValueAssert doesNotHaveMatchedRules(Collection<? extends MatchedRuleValue> matchedRules) {
        this.isNotNull();
        if (matchedRules == null) {
            this.failWithMessage("Expecting matchedRules parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((EvaluatedDecisionValue)this.actual).getMatchedRules(), matchedRules.toArray());
        return this;
    }

    public EvaluatedDecisionValueAssert hasNoMatchedRules() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have matchedRules but had :\n  <%s>";
        if (((EvaluatedDecisionValue)this.actual).getMatchedRules().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((EvaluatedDecisionValue)this.actual).getMatchedRules()});
        }
        return this;
    }

    public EvaluatedDecisionValueAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((EvaluatedDecisionValue)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }
}

