/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import java.util.Collection;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class JobBatchRecordValueAssert
extends AbstractObjectAssert<JobBatchRecordValueAssert, JobBatchRecordValue> {
    public JobBatchRecordValueAssert(JobBatchRecordValue actual) {
        super((Object)actual, JobBatchRecordValueAssert.class);
    }

    @CheckReturnValue
    public static JobBatchRecordValueAssert assertThat(JobBatchRecordValue actual) {
        return new JobBatchRecordValueAssert(actual);
    }

    public JobBatchRecordValueAssert hasJobKeys(Long ... jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), (Object[])jobKeys);
        return this;
    }

    public JobBatchRecordValueAssert hasJobKeys(Collection<? extends Long> jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), jobKeys.toArray());
        return this;
    }

    public JobBatchRecordValueAssert hasOnlyJobKeys(Long ... jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), (Object[])jobKeys);
        return this;
    }

    public JobBatchRecordValueAssert hasOnlyJobKeys(Collection<? extends Long> jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), jobKeys.toArray());
        return this;
    }

    public JobBatchRecordValueAssert doesNotHaveJobKeys(Long ... jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), (Object[])jobKeys);
        return this;
    }

    public JobBatchRecordValueAssert doesNotHaveJobKeys(Collection<? extends Long> jobKeys) {
        this.isNotNull();
        if (jobKeys == null) {
            this.failWithMessage("Expecting jobKeys parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobKeys(), jobKeys.toArray());
        return this;
    }

    public JobBatchRecordValueAssert hasNoJobKeys() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have jobKeys but had :\n  <%s>";
        if (((JobBatchRecordValue)this.actual).getJobKeys().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((JobBatchRecordValue)this.actual).getJobKeys()});
        }
        return this;
    }

    public JobBatchRecordValueAssert hasJobs(JobRecordValue ... jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), (Object[])jobs);
        return this;
    }

    public JobBatchRecordValueAssert hasJobs(Collection<? extends JobRecordValue> jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), jobs.toArray());
        return this;
    }

    public JobBatchRecordValueAssert hasOnlyJobs(JobRecordValue ... jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), (Object[])jobs);
        return this;
    }

    public JobBatchRecordValueAssert hasOnlyJobs(Collection<? extends JobRecordValue> jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), jobs.toArray());
        return this;
    }

    public JobBatchRecordValueAssert doesNotHaveJobs(JobRecordValue ... jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), (Object[])jobs);
        return this;
    }

    public JobBatchRecordValueAssert doesNotHaveJobs(Collection<? extends JobRecordValue> jobs) {
        this.isNotNull();
        if (jobs == null) {
            this.failWithMessage("Expecting jobs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getJobs(), jobs.toArray());
        return this;
    }

    public JobBatchRecordValueAssert hasNoJobs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have jobs but had :\n  <%s>";
        if (((JobBatchRecordValue)this.actual).getJobs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((JobBatchRecordValue)this.actual).getJobs()});
        }
        return this;
    }

    public JobBatchRecordValueAssert hasMaxJobsToActivate(int maxJobsToActivate) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting maxJobsToActivate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualMaxJobsToActivate = ((JobBatchRecordValue)this.actual).getMaxJobsToActivate();
        if (actualMaxJobsToActivate != maxJobsToActivate) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, maxJobsToActivate, actualMaxJobsToActivate});
        }
        return this;
    }

    public JobBatchRecordValueAssert hasTenantIds(String ... tenantIds) {
        this.isNotNull();
        if (tenantIds == null) {
            this.failWithMessage("Expecting tenantIds parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getTenantIds(), (Object[])tenantIds);
        return this;
    }

    public JobBatchRecordValueAssert hasTenantIds(Collection<? extends String> tenantIds) {
        this.isNotNull();
        if (tenantIds == null) {
            this.failWithMessage("Expecting tenantIds parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getTenantIds(), tenantIds.toArray());
        return this;
    }

    public JobBatchRecordValueAssert hasOnlyTenantIds(String ... tenantIds) {
        this.isNotNull();
        if (tenantIds == null) {
            this.failWithMessage("Expecting tenantIds parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getTenantIds(), (Object[])tenantIds);
        return this;
    }

    public JobBatchRecordValueAssert hasOnlyTenantIds(Collection<? extends String> tenantIds) {
        this.isNotNull();
        if (tenantIds == null) {
            this.failWithMessage("Expecting tenantIds parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getTenantIds(), tenantIds.toArray());
        return this;
    }

    public JobBatchRecordValueAssert doesNotHaveTenantIds(String ... tenantIds) {
        this.isNotNull();
        if (tenantIds == null) {
            this.failWithMessage("Expecting tenantIds parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getTenantIds(), (Object[])tenantIds);
        return this;
    }

    public JobBatchRecordValueAssert doesNotHaveTenantIds(Collection<? extends String> tenantIds) {
        this.isNotNull();
        if (tenantIds == null) {
            this.failWithMessage("Expecting tenantIds parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((JobBatchRecordValue)this.actual).getTenantIds(), tenantIds.toArray());
        return this;
    }

    public JobBatchRecordValueAssert hasNoTenantIds() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have tenantIds but had :\n  <%s>";
        if (((JobBatchRecordValue)this.actual).getTenantIds().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((JobBatchRecordValue)this.actual).getTenantIds()});
        }
        return this;
    }

    public JobBatchRecordValueAssert hasTimeout(long timeout) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting timeout of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualTimeout = ((JobBatchRecordValue)this.actual).getTimeout();
        if (actualTimeout != timeout) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, timeout, actualTimeout});
        }
        return this;
    }

    public JobBatchRecordValueAssert isTruncated() {
        this.isNotNull();
        if (!((JobBatchRecordValue)this.actual).isTruncated()) {
            this.failWithMessage("\nExpecting that actual JobBatchRecordValue is truncated but is not.", new Object[0]);
        }
        return this;
    }

    public JobBatchRecordValueAssert isNotTruncated() {
        this.isNotNull();
        if (((JobBatchRecordValue)this.actual).isTruncated()) {
            this.failWithMessage("\nExpecting that actual JobBatchRecordValue is not truncated but is.", new Object[0]);
        }
        return this;
    }

    public JobBatchRecordValueAssert hasType(String type) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualType = ((JobBatchRecordValue)this.actual).getType();
        if (!Objects.areEqual((Object)actualType, (Object)type)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, type, actualType});
        }
        return this;
    }

    public JobBatchRecordValueAssert hasWorker(String worker) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting worker of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualWorker = ((JobBatchRecordValue)this.actual).getWorker();
        if (!Objects.areEqual((Object)actualWorker, (Object)worker)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, worker, actualWorker});
        }
        return this;
    }
}

