/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import io.camunda.zeebe.protocol.record.value.JobKind;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class JobRecordValueAssert
extends AbstractObjectAssert<JobRecordValueAssert, JobRecordValue> {
    public JobRecordValueAssert(JobRecordValue actual) {
        super((Object)actual, JobRecordValueAssert.class);
    }

    @CheckReturnValue
    public static JobRecordValueAssert assertThat(JobRecordValue actual) {
        return new JobRecordValueAssert(actual);
    }

    public JobRecordValueAssert hasBpmnProcessId(String bpmnProcessId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualBpmnProcessId = ((JobRecordValue)this.actual).getBpmnProcessId();
        if (!Objects.areEqual((Object)actualBpmnProcessId, (Object)bpmnProcessId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, bpmnProcessId, actualBpmnProcessId});
        }
        return this;
    }

    public JobRecordValueAssert hasCustomHeaders(Map customHeaders) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting customHeaders of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualCustomHeaders = ((JobRecordValue)this.actual).getCustomHeaders();
        if (!Objects.areEqual((Object)actualCustomHeaders, (Object)customHeaders)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, customHeaders, actualCustomHeaders});
        }
        return this;
    }

    public JobRecordValueAssert hasDeadline(long deadline) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting deadline of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualDeadline = ((JobRecordValue)this.actual).getDeadline();
        if (actualDeadline != deadline) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, deadline, actualDeadline});
        }
        return this;
    }

    public JobRecordValueAssert hasElementId(String elementId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting elementId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualElementId = ((JobRecordValue)this.actual).getElementId();
        if (!Objects.areEqual((Object)actualElementId, (Object)elementId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, elementId, actualElementId});
        }
        return this;
    }

    public JobRecordValueAssert hasElementInstanceKey(long elementInstanceKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting elementInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualElementInstanceKey = ((JobRecordValue)this.actual).getElementInstanceKey();
        if (actualElementInstanceKey != elementInstanceKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, elementInstanceKey, actualElementInstanceKey});
        }
        return this;
    }

    public JobRecordValueAssert hasErrorCode(String errorCode) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting errorCode of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualErrorCode = ((JobRecordValue)this.actual).getErrorCode();
        if (!Objects.areEqual((Object)actualErrorCode, (Object)errorCode)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, errorCode, actualErrorCode});
        }
        return this;
    }

    public JobRecordValueAssert hasErrorMessage(String errorMessage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting errorMessage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualErrorMessage = ((JobRecordValue)this.actual).getErrorMessage();
        if (!Objects.areEqual((Object)actualErrorMessage, (Object)errorMessage)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, errorMessage, actualErrorMessage});
        }
        return this;
    }

    public JobRecordValueAssert hasJobKind(JobKind jobKind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting jobKind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        JobKind actualJobKind = ((JobRecordValue)this.actual).getJobKind();
        if (!Objects.areEqual((Object)actualJobKind, (Object)jobKind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, jobKind, actualJobKind});
        }
        return this;
    }

    public JobRecordValueAssert hasProcessDefinitionKey(long processDefinitionKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualProcessDefinitionKey = ((JobRecordValue)this.actual).getProcessDefinitionKey();
        if (actualProcessDefinitionKey != processDefinitionKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, processDefinitionKey, actualProcessDefinitionKey});
        }
        return this;
    }

    public JobRecordValueAssert hasProcessDefinitionVersion(int processDefinitionVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting processDefinitionVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualProcessDefinitionVersion = ((JobRecordValue)this.actual).getProcessDefinitionVersion();
        if (actualProcessDefinitionVersion != processDefinitionVersion) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, processDefinitionVersion, actualProcessDefinitionVersion});
        }
        return this;
    }

    public JobRecordValueAssert hasProcessInstanceKey(long processInstanceKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualProcessInstanceKey = ((JobRecordValue)this.actual).getProcessInstanceKey();
        if (actualProcessInstanceKey != processInstanceKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, processInstanceKey, actualProcessInstanceKey});
        }
        return this;
    }

    public JobRecordValueAssert hasRecurringTime(long recurringTime) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting recurringTime of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualRecurringTime = ((JobRecordValue)this.actual).getRecurringTime();
        if (actualRecurringTime != recurringTime) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, recurringTime, actualRecurringTime});
        }
        return this;
    }

    public JobRecordValueAssert hasRetries(int retries) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting retries of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualRetries = ((JobRecordValue)this.actual).getRetries();
        if (actualRetries != retries) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, retries, actualRetries});
        }
        return this;
    }

    public JobRecordValueAssert hasRetryBackoff(long retryBackoff) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting retryBackoff of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualRetryBackoff = ((JobRecordValue)this.actual).getRetryBackoff();
        if (actualRetryBackoff != retryBackoff) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, retryBackoff, actualRetryBackoff});
        }
        return this;
    }

    public JobRecordValueAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((JobRecordValue)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }

    public JobRecordValueAssert hasTimeout(long timeout) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting timeout of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualTimeout = ((JobRecordValue)this.actual).getTimeout();
        if (actualTimeout != timeout) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, timeout, actualTimeout});
        }
        return this;
    }

    public JobRecordValueAssert hasType(String type) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualType = ((JobRecordValue)this.actual).getType();
        if (!Objects.areEqual((Object)actualType, (Object)type)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, type, actualType});
        }
        return this;
    }

    public JobRecordValueAssert hasVariables(Map variables) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting variables of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualVariables = ((JobRecordValue)this.actual).getVariables();
        if (!Objects.areEqual((Object)actualVariables, (Object)variables)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, variables, actualVariables});
        }
        return this;
    }

    public JobRecordValueAssert hasWorker(String worker) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting worker of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualWorker = ((JobRecordValue)this.actual).getWorker();
        if (!Objects.areEqual((Object)actualWorker, (Object)worker)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, worker, actualWorker});
        }
        return this;
    }
}

