/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import io.camunda.zeebe.protocol.record.value.EvaluatedOutputValue;
import io.camunda.zeebe.protocol.record.value.MatchedRuleValue;
import java.util.Collection;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class MatchedRuleValueAssert
extends AbstractObjectAssert<MatchedRuleValueAssert, MatchedRuleValue> {
    public MatchedRuleValueAssert(MatchedRuleValue actual) {
        super((Object)actual, MatchedRuleValueAssert.class);
    }

    @CheckReturnValue
    public static MatchedRuleValueAssert assertThat(MatchedRuleValue actual) {
        return new MatchedRuleValueAssert(actual);
    }

    public MatchedRuleValueAssert hasEvaluatedOutputs(EvaluatedOutputValue ... evaluatedOutputs) {
        this.isNotNull();
        if (evaluatedOutputs == null) {
            this.failWithMessage("Expecting evaluatedOutputs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MatchedRuleValue)this.actual).getEvaluatedOutputs(), (Object[])evaluatedOutputs);
        return this;
    }

    public MatchedRuleValueAssert hasEvaluatedOutputs(Collection<? extends EvaluatedOutputValue> evaluatedOutputs) {
        this.isNotNull();
        if (evaluatedOutputs == null) {
            this.failWithMessage("Expecting evaluatedOutputs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MatchedRuleValue)this.actual).getEvaluatedOutputs(), evaluatedOutputs.toArray());
        return this;
    }

    public MatchedRuleValueAssert hasOnlyEvaluatedOutputs(EvaluatedOutputValue ... evaluatedOutputs) {
        this.isNotNull();
        if (evaluatedOutputs == null) {
            this.failWithMessage("Expecting evaluatedOutputs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MatchedRuleValue)this.actual).getEvaluatedOutputs(), (Object[])evaluatedOutputs);
        return this;
    }

    public MatchedRuleValueAssert hasOnlyEvaluatedOutputs(Collection<? extends EvaluatedOutputValue> evaluatedOutputs) {
        this.isNotNull();
        if (evaluatedOutputs == null) {
            this.failWithMessage("Expecting evaluatedOutputs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MatchedRuleValue)this.actual).getEvaluatedOutputs(), evaluatedOutputs.toArray());
        return this;
    }

    public MatchedRuleValueAssert doesNotHaveEvaluatedOutputs(EvaluatedOutputValue ... evaluatedOutputs) {
        this.isNotNull();
        if (evaluatedOutputs == null) {
            this.failWithMessage("Expecting evaluatedOutputs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MatchedRuleValue)this.actual).getEvaluatedOutputs(), (Object[])evaluatedOutputs);
        return this;
    }

    public MatchedRuleValueAssert doesNotHaveEvaluatedOutputs(Collection<? extends EvaluatedOutputValue> evaluatedOutputs) {
        this.isNotNull();
        if (evaluatedOutputs == null) {
            this.failWithMessage("Expecting evaluatedOutputs parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MatchedRuleValue)this.actual).getEvaluatedOutputs(), evaluatedOutputs.toArray());
        return this;
    }

    public MatchedRuleValueAssert hasNoEvaluatedOutputs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have evaluatedOutputs but had :\n  <%s>";
        if (((MatchedRuleValue)this.actual).getEvaluatedOutputs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MatchedRuleValue)this.actual).getEvaluatedOutputs()});
        }
        return this;
    }

    public MatchedRuleValueAssert hasRuleId(String ruleId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting ruleId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualRuleId = ((MatchedRuleValue)this.actual).getRuleId();
        if (!Objects.areEqual((Object)actualRuleId, (Object)ruleId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ruleId, actualRuleId});
        }
        return this;
    }

    public MatchedRuleValueAssert hasRuleIndex(int ruleIndex) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting ruleIndex of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualRuleIndex = ((MatchedRuleValue)this.actual).getRuleIndex();
        if (actualRuleIndex != ruleIndex) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ruleIndex, actualRuleIndex});
        }
        return this;
    }
}

