/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class MessageRecordValueAssert
extends AbstractObjectAssert<MessageRecordValueAssert, MessageRecordValue> {
    public MessageRecordValueAssert(MessageRecordValue actual) {
        super((Object)actual, MessageRecordValueAssert.class);
    }

    @CheckReturnValue
    public static MessageRecordValueAssert assertThat(MessageRecordValue actual) {
        return new MessageRecordValueAssert(actual);
    }

    public MessageRecordValueAssert hasCorrelationKey(String correlationKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting correlationKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualCorrelationKey = ((MessageRecordValue)this.actual).getCorrelationKey();
        if (!Objects.areEqual((Object)actualCorrelationKey, (Object)correlationKey)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, correlationKey, actualCorrelationKey});
        }
        return this;
    }

    public MessageRecordValueAssert hasDeadline(long deadline) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting deadline of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualDeadline = ((MessageRecordValue)this.actual).getDeadline();
        if (actualDeadline != deadline) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, deadline, actualDeadline});
        }
        return this;
    }

    public MessageRecordValueAssert hasMessageId(String messageId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting messageId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualMessageId = ((MessageRecordValue)this.actual).getMessageId();
        if (!Objects.areEqual((Object)actualMessageId, (Object)messageId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, messageId, actualMessageId});
        }
        return this;
    }

    public MessageRecordValueAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((MessageRecordValue)this.actual).getName();
        if (!Objects.areEqual((Object)actualName, (Object)name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public MessageRecordValueAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((MessageRecordValue)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }

    public MessageRecordValueAssert hasTimeToLive(long timeToLive) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting timeToLive of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualTimeToLive = ((MessageRecordValue)this.actual).getTimeToLive();
        if (actualTimeToLive != timeToLive) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, timeToLive, actualTimeToLive});
        }
        return this;
    }

    public MessageRecordValueAssert hasVariables(Map variables) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting variables of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualVariables = ((MessageRecordValue)this.actual).getVariables();
        if (!Objects.areEqual((Object)actualVariables, (Object)variables)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, variables, actualVariables});
        }
        return this;
    }
}

