/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class ProcessInstanceCreationRecordValueAssert
extends AbstractObjectAssert<ProcessInstanceCreationRecordValueAssert, ProcessInstanceCreationRecordValue> {
    public ProcessInstanceCreationRecordValueAssert(ProcessInstanceCreationRecordValue actual) {
        super((Object)actual, ProcessInstanceCreationRecordValueAssert.class);
    }

    @CheckReturnValue
    public static ProcessInstanceCreationRecordValueAssert assertThat(ProcessInstanceCreationRecordValue actual) {
        return new ProcessInstanceCreationRecordValueAssert(actual);
    }

    public ProcessInstanceCreationRecordValueAssert hasBpmnProcessId(String bpmnProcessId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualBpmnProcessId = ((ProcessInstanceCreationRecordValue)this.actual).getBpmnProcessId();
        if (!Objects.areEqual((Object)actualBpmnProcessId, (Object)bpmnProcessId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, bpmnProcessId, actualBpmnProcessId});
        }
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert hasProcessDefinitionKey(long processDefinitionKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualProcessDefinitionKey = ((ProcessInstanceCreationRecordValue)this.actual).getProcessDefinitionKey();
        if (actualProcessDefinitionKey != processDefinitionKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, processDefinitionKey, actualProcessDefinitionKey});
        }
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert hasProcessInstanceKey(long processInstanceKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting processInstanceKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualProcessInstanceKey = ((ProcessInstanceCreationRecordValue)this.actual).getProcessInstanceKey();
        if (actualProcessInstanceKey != processInstanceKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, processInstanceKey, actualProcessInstanceKey});
        }
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert hasStartInstructions(ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue ... startInstructions) {
        this.isNotNull();
        if (startInstructions == null) {
            this.failWithMessage("Expecting startInstructions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ProcessInstanceCreationRecordValue)this.actual).getStartInstructions(), (Object[])startInstructions);
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert hasStartInstructions(Collection<? extends ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> startInstructions) {
        this.isNotNull();
        if (startInstructions == null) {
            this.failWithMessage("Expecting startInstructions parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ProcessInstanceCreationRecordValue)this.actual).getStartInstructions(), startInstructions.toArray());
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert hasOnlyStartInstructions(ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue ... startInstructions) {
        this.isNotNull();
        if (startInstructions == null) {
            this.failWithMessage("Expecting startInstructions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ProcessInstanceCreationRecordValue)this.actual).getStartInstructions(), (Object[])startInstructions);
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert hasOnlyStartInstructions(Collection<? extends ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> startInstructions) {
        this.isNotNull();
        if (startInstructions == null) {
            this.failWithMessage("Expecting startInstructions parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ProcessInstanceCreationRecordValue)this.actual).getStartInstructions(), startInstructions.toArray());
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert doesNotHaveStartInstructions(ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue ... startInstructions) {
        this.isNotNull();
        if (startInstructions == null) {
            this.failWithMessage("Expecting startInstructions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ProcessInstanceCreationRecordValue)this.actual).getStartInstructions(), (Object[])startInstructions);
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert doesNotHaveStartInstructions(Collection<? extends ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> startInstructions) {
        this.isNotNull();
        if (startInstructions == null) {
            this.failWithMessage("Expecting startInstructions parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ProcessInstanceCreationRecordValue)this.actual).getStartInstructions(), startInstructions.toArray());
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert hasNoStartInstructions() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have startInstructions but had :\n  <%s>";
        if (((ProcessInstanceCreationRecordValue)this.actual).getStartInstructions().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ProcessInstanceCreationRecordValue)this.actual).getStartInstructions()});
        }
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((ProcessInstanceCreationRecordValue)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert hasVariables(Map variables) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting variables of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualVariables = ((ProcessInstanceCreationRecordValue)this.actual).getVariables();
        if (!Objects.areEqual((Object)actualVariables, (Object)variables)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, variables, actualVariables});
        }
        return this;
    }

    public ProcessInstanceCreationRecordValueAssert hasVersion(int version) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualVersion = ((ProcessInstanceCreationRecordValue)this.actual).getVersion();
        if (actualVersion != version) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, version, actualVersion});
        }
        return this;
    }
}

