/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class DecisionRecordValueAssert
extends AbstractObjectAssert<DecisionRecordValueAssert, DecisionRecordValue> {
    public DecisionRecordValueAssert(DecisionRecordValue actual) {
        super((Object)actual, DecisionRecordValueAssert.class);
    }

    @CheckReturnValue
    public static DecisionRecordValueAssert assertThat(DecisionRecordValue actual) {
        return new DecisionRecordValueAssert(actual);
    }

    public DecisionRecordValueAssert hasDecisionId(String decisionId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionId = ((DecisionRecordValue)this.actual).getDecisionId();
        if (!Objects.areEqual((Object)actualDecisionId, (Object)decisionId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionId, actualDecisionId});
        }
        return this;
    }

    public DecisionRecordValueAssert hasDecisionKey(long decisionKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualDecisionKey = ((DecisionRecordValue)this.actual).getDecisionKey();
        if (actualDecisionKey != decisionKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionKey, actualDecisionKey});
        }
        return this;
    }

    public DecisionRecordValueAssert hasDecisionName(String decisionName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionName = ((DecisionRecordValue)this.actual).getDecisionName();
        if (!Objects.areEqual((Object)actualDecisionName, (Object)decisionName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionName, actualDecisionName});
        }
        return this;
    }

    public DecisionRecordValueAssert hasDecisionRequirementsId(String decisionRequirementsId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionRequirementsId = ((DecisionRecordValue)this.actual).getDecisionRequirementsId();
        if (!Objects.areEqual((Object)actualDecisionRequirementsId, (Object)decisionRequirementsId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsId, actualDecisionRequirementsId});
        }
        return this;
    }

    public DecisionRecordValueAssert hasDecisionRequirementsKey(long decisionRequirementsKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualDecisionRequirementsKey = ((DecisionRecordValue)this.actual).getDecisionRequirementsKey();
        if (actualDecisionRequirementsKey != decisionRequirementsKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsKey, actualDecisionRequirementsKey});
        }
        return this;
    }

    public DecisionRecordValueAssert isDuplicate() {
        this.isNotNull();
        if (!((DecisionRecordValue)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual DecisionRecordValue is duplicate but is not.", new Object[0]);
        }
        return this;
    }

    public DecisionRecordValueAssert isNotDuplicate() {
        this.isNotNull();
        if (((DecisionRecordValue)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual DecisionRecordValue is not duplicate but is.", new Object[0]);
        }
        return this;
    }

    public DecisionRecordValueAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((DecisionRecordValue)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }

    public DecisionRecordValueAssert hasVersion(int version) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualVersion = ((DecisionRecordValue)this.actual).getVersion();
        if (actualVersion != version) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, version, actualVersion});
        }
        return this;
    }
}

