/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import java.util.Arrays;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class DecisionRequirementsMetadataValueAssert
extends AbstractObjectAssert<DecisionRequirementsMetadataValueAssert, DecisionRequirementsMetadataValue> {
    public DecisionRequirementsMetadataValueAssert(DecisionRequirementsMetadataValue actual) {
        super((Object)actual, DecisionRequirementsMetadataValueAssert.class);
    }

    @CheckReturnValue
    public static DecisionRequirementsMetadataValueAssert assertThat(DecisionRequirementsMetadataValue actual) {
        return new DecisionRequirementsMetadataValueAssert(actual);
    }

    public DecisionRequirementsMetadataValueAssert hasChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DecisionRequirementsMetadataValue)this.actual).getChecksum()).contains(checksum);
        return this;
    }

    public DecisionRequirementsMetadataValueAssert hasOnlyChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DecisionRequirementsMetadataValue)this.actual).getChecksum()).containsOnly(checksum);
        return this;
    }

    public DecisionRequirementsMetadataValueAssert doesNotHaveChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DecisionRequirementsMetadataValue)this.actual).getChecksum()).doesNotContain(checksum);
        return this;
    }

    public DecisionRequirementsMetadataValueAssert hasNoChecksum() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have checksum but had :\n  <%s>";
        if (((DecisionRequirementsMetadataValue)this.actual).getChecksum().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((DecisionRequirementsMetadataValue)this.actual).getChecksum())});
        }
        return this;
    }

    public DecisionRequirementsMetadataValueAssert hasDecisionRequirementsId(String decisionRequirementsId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionRequirementsId = ((DecisionRequirementsMetadataValue)this.actual).getDecisionRequirementsId();
        if (!Objects.areEqual((Object)actualDecisionRequirementsId, (Object)decisionRequirementsId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsId, actualDecisionRequirementsId});
        }
        return this;
    }

    public DecisionRequirementsMetadataValueAssert hasDecisionRequirementsKey(long decisionRequirementsKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualDecisionRequirementsKey = ((DecisionRequirementsMetadataValue)this.actual).getDecisionRequirementsKey();
        if (actualDecisionRequirementsKey != decisionRequirementsKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsKey, actualDecisionRequirementsKey});
        }
        return this;
    }

    public DecisionRequirementsMetadataValueAssert hasDecisionRequirementsName(String decisionRequirementsName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionRequirementsName = ((DecisionRequirementsMetadataValue)this.actual).getDecisionRequirementsName();
        if (!Objects.areEqual((Object)actualDecisionRequirementsName, (Object)decisionRequirementsName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsName, actualDecisionRequirementsName});
        }
        return this;
    }

    public DecisionRequirementsMetadataValueAssert hasDecisionRequirementsVersion(int decisionRequirementsVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualDecisionRequirementsVersion = ((DecisionRequirementsMetadataValue)this.actual).getDecisionRequirementsVersion();
        if (actualDecisionRequirementsVersion != decisionRequirementsVersion) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsVersion, actualDecisionRequirementsVersion});
        }
        return this;
    }

    public DecisionRequirementsMetadataValueAssert isDuplicate() {
        this.isNotNull();
        if (!((DecisionRequirementsMetadataValue)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual DecisionRequirementsMetadataValue is duplicate but is not.", new Object[0]);
        }
        return this;
    }

    public DecisionRequirementsMetadataValueAssert isNotDuplicate() {
        this.isNotNull();
        if (((DecisionRequirementsMetadataValue)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual DecisionRequirementsMetadataValue is not duplicate but is.", new Object[0]);
        }
        return this;
    }

    public DecisionRequirementsMetadataValueAssert hasNamespace(String namespace) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualNamespace = ((DecisionRequirementsMetadataValue)this.actual).getNamespace();
        if (!Objects.areEqual((Object)actualNamespace, (Object)namespace)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, namespace, actualNamespace});
        }
        return this;
    }

    public DecisionRequirementsMetadataValueAssert hasResourceName(String resourceName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualResourceName = ((DecisionRequirementsMetadataValue)this.actual).getResourceName();
        if (!Objects.areEqual((Object)actualResourceName, (Object)resourceName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceName, actualResourceName});
        }
        return this;
    }

    public DecisionRequirementsMetadataValueAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((DecisionRequirementsMetadataValue)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }
}

