/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsRecordValue;
import java.util.Arrays;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class DecisionRequirementsRecordValueAssert
extends AbstractObjectAssert<DecisionRequirementsRecordValueAssert, DecisionRequirementsRecordValue> {
    public DecisionRequirementsRecordValueAssert(DecisionRequirementsRecordValue actual) {
        super((Object)actual, DecisionRequirementsRecordValueAssert.class);
    }

    @CheckReturnValue
    public static DecisionRequirementsRecordValueAssert assertThat(DecisionRequirementsRecordValue actual) {
        return new DecisionRequirementsRecordValueAssert(actual);
    }

    public DecisionRequirementsRecordValueAssert hasChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DecisionRequirementsRecordValue)this.actual).getChecksum()).contains(checksum);
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasOnlyChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DecisionRequirementsRecordValue)this.actual).getChecksum()).containsOnly(checksum);
        return this;
    }

    public DecisionRequirementsRecordValueAssert doesNotHaveChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DecisionRequirementsRecordValue)this.actual).getChecksum()).doesNotContain(checksum);
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasNoChecksum() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have checksum but had :\n  <%s>";
        if (((DecisionRequirementsRecordValue)this.actual).getChecksum().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((DecisionRequirementsRecordValue)this.actual).getChecksum())});
        }
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasDecisionRequirementsId(String decisionRequirementsId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionRequirementsId = ((DecisionRequirementsRecordValue)this.actual).getDecisionRequirementsId();
        if (!Objects.areEqual((Object)actualDecisionRequirementsId, (Object)decisionRequirementsId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsId, actualDecisionRequirementsId});
        }
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasDecisionRequirementsKey(long decisionRequirementsKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualDecisionRequirementsKey = ((DecisionRequirementsRecordValue)this.actual).getDecisionRequirementsKey();
        if (actualDecisionRequirementsKey != decisionRequirementsKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsKey, actualDecisionRequirementsKey});
        }
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasDecisionRequirementsName(String decisionRequirementsName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDecisionRequirementsName = ((DecisionRequirementsRecordValue)this.actual).getDecisionRequirementsName();
        if (!Objects.areEqual((Object)actualDecisionRequirementsName, (Object)decisionRequirementsName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsName, actualDecisionRequirementsName});
        }
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasDecisionRequirementsVersion(int decisionRequirementsVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting decisionRequirementsVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualDecisionRequirementsVersion = ((DecisionRequirementsRecordValue)this.actual).getDecisionRequirementsVersion();
        if (actualDecisionRequirementsVersion != decisionRequirementsVersion) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, decisionRequirementsVersion, actualDecisionRequirementsVersion});
        }
        return this;
    }

    public DecisionRequirementsRecordValueAssert isDuplicate() {
        this.isNotNull();
        if (!((DecisionRequirementsRecordValue)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual DecisionRequirementsRecordValue is duplicate but is not.", new Object[0]);
        }
        return this;
    }

    public DecisionRequirementsRecordValueAssert isNotDuplicate() {
        this.isNotNull();
        if (((DecisionRequirementsRecordValue)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual DecisionRequirementsRecordValue is not duplicate but is.", new Object[0]);
        }
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasNamespace(String namespace) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualNamespace = ((DecisionRequirementsRecordValue)this.actual).getNamespace();
        if (!Objects.areEqual((Object)actualNamespace, (Object)namespace)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, namespace, actualNamespace});
        }
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DecisionRequirementsRecordValue)this.actual).getResource()).contains(resource);
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasOnlyResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DecisionRequirementsRecordValue)this.actual).getResource()).containsOnly(resource);
        return this;
    }

    public DecisionRequirementsRecordValueAssert doesNotHaveResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DecisionRequirementsRecordValue)this.actual).getResource()).doesNotContain(resource);
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasNoResource() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resource but had :\n  <%s>";
        if (((DecisionRequirementsRecordValue)this.actual).getResource().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((DecisionRequirementsRecordValue)this.actual).getResource())});
        }
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasResourceName(String resourceName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualResourceName = ((DecisionRequirementsRecordValue)this.actual).getResourceName();
        if (!Objects.areEqual((Object)actualResourceName, (Object)resourceName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceName, actualResourceName});
        }
        return this;
    }

    public DecisionRequirementsRecordValueAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((DecisionRequirementsRecordValue)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }
}

