/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import java.util.Arrays;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class DeploymentResourceAssert
extends AbstractObjectAssert<DeploymentResourceAssert, DeploymentResource> {
    public DeploymentResourceAssert(DeploymentResource actual) {
        super((Object)actual, DeploymentResourceAssert.class);
    }

    @CheckReturnValue
    public static DeploymentResourceAssert assertThat(DeploymentResource actual) {
        return new DeploymentResourceAssert(actual);
    }

    public DeploymentResourceAssert hasResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DeploymentResource)this.actual).getResource()).contains(resource);
        return this;
    }

    public DeploymentResourceAssert hasOnlyResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DeploymentResource)this.actual).getResource()).containsOnly(resource);
        return this;
    }

    public DeploymentResourceAssert doesNotHaveResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((DeploymentResource)this.actual).getResource()).doesNotContain(resource);
        return this;
    }

    public DeploymentResourceAssert hasNoResource() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resource but had :\n  <%s>";
        if (((DeploymentResource)this.actual).getResource().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((DeploymentResource)this.actual).getResource())});
        }
        return this;
    }

    public DeploymentResourceAssert hasResourceName(String resourceName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualResourceName = ((DeploymentResource)this.actual).getResourceName();
        if (!Objects.areEqual((Object)actualResourceName, (Object)resourceName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceName, actualResourceName});
        }
        return this;
    }
}

