/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import io.camunda.zeebe.protocol.record.value.deployment.Form;
import java.util.Arrays;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class FormAssert
extends AbstractObjectAssert<FormAssert, Form> {
    public FormAssert(Form actual) {
        super((Object)actual, FormAssert.class);
    }

    @CheckReturnValue
    public static FormAssert assertThat(Form actual) {
        return new FormAssert(actual);
    }

    public FormAssert hasChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Form)this.actual).getChecksum()).contains(checksum);
        return this;
    }

    public FormAssert hasOnlyChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Form)this.actual).getChecksum()).containsOnly(checksum);
        return this;
    }

    public FormAssert doesNotHaveChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Form)this.actual).getChecksum()).doesNotContain(checksum);
        return this;
    }

    public FormAssert hasNoChecksum() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have checksum but had :\n  <%s>";
        if (((Form)this.actual).getChecksum().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((Form)this.actual).getChecksum())});
        }
        return this;
    }

    public FormAssert isDuplicate() {
        this.isNotNull();
        if (!((Form)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual Form is duplicate but is not.", new Object[0]);
        }
        return this;
    }

    public FormAssert isNotDuplicate() {
        this.isNotNull();
        if (((Form)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual Form is not duplicate but is.", new Object[0]);
        }
        return this;
    }

    public FormAssert hasFormId(String formId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting formId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFormId = ((Form)this.actual).getFormId();
        if (!Objects.areEqual((Object)actualFormId, (Object)formId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, formId, actualFormId});
        }
        return this;
    }

    public FormAssert hasFormKey(long formKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting formKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualFormKey = ((Form)this.actual).getFormKey();
        if (actualFormKey != formKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, formKey, actualFormKey});
        }
        return this;
    }

    public FormAssert hasResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Form)this.actual).getResource()).contains(resource);
        return this;
    }

    public FormAssert hasOnlyResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Form)this.actual).getResource()).containsOnly(resource);
        return this;
    }

    public FormAssert doesNotHaveResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Form)this.actual).getResource()).doesNotContain(resource);
        return this;
    }

    public FormAssert hasNoResource() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resource but had :\n  <%s>";
        if (((Form)this.actual).getResource().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((Form)this.actual).getResource())});
        }
        return this;
    }

    public FormAssert hasResourceName(String resourceName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualResourceName = ((Form)this.actual).getResourceName();
        if (!Objects.areEqual((Object)actualResourceName, (Object)resourceName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceName, actualResourceName});
        }
        return this;
    }

    public FormAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((Form)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }

    public FormAssert hasVersion(int version) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualVersion = ((Form)this.actual).getVersion();
        if (actualVersion != version) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, version, actualVersion});
        }
        return this;
    }
}

