/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import java.util.Arrays;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class FormMetadataValueAssert
extends AbstractObjectAssert<FormMetadataValueAssert, FormMetadataValue> {
    public FormMetadataValueAssert(FormMetadataValue actual) {
        super((Object)actual, FormMetadataValueAssert.class);
    }

    @CheckReturnValue
    public static FormMetadataValueAssert assertThat(FormMetadataValue actual) {
        return new FormMetadataValueAssert(actual);
    }

    public FormMetadataValueAssert hasChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((FormMetadataValue)this.actual).getChecksum()).contains(checksum);
        return this;
    }

    public FormMetadataValueAssert hasOnlyChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((FormMetadataValue)this.actual).getChecksum()).containsOnly(checksum);
        return this;
    }

    public FormMetadataValueAssert doesNotHaveChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((FormMetadataValue)this.actual).getChecksum()).doesNotContain(checksum);
        return this;
    }

    public FormMetadataValueAssert hasNoChecksum() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have checksum but had :\n  <%s>";
        if (((FormMetadataValue)this.actual).getChecksum().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((FormMetadataValue)this.actual).getChecksum())});
        }
        return this;
    }

    public FormMetadataValueAssert isDuplicate() {
        this.isNotNull();
        if (!((FormMetadataValue)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual FormMetadataValue is duplicate but is not.", new Object[0]);
        }
        return this;
    }

    public FormMetadataValueAssert isNotDuplicate() {
        this.isNotNull();
        if (((FormMetadataValue)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual FormMetadataValue is not duplicate but is.", new Object[0]);
        }
        return this;
    }

    public FormMetadataValueAssert hasFormId(String formId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting formId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFormId = ((FormMetadataValue)this.actual).getFormId();
        if (!Objects.areEqual((Object)actualFormId, (Object)formId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, formId, actualFormId});
        }
        return this;
    }

    public FormMetadataValueAssert hasFormKey(long formKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting formKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualFormKey = ((FormMetadataValue)this.actual).getFormKey();
        if (actualFormKey != formKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, formKey, actualFormKey});
        }
        return this;
    }

    public FormMetadataValueAssert hasResourceName(String resourceName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualResourceName = ((FormMetadataValue)this.actual).getResourceName();
        if (!Objects.areEqual((Object)actualResourceName, (Object)resourceName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceName, actualResourceName});
        }
        return this;
    }

    public FormMetadataValueAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((FormMetadataValue)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }

    public FormMetadataValueAssert hasVersion(int version) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualVersion = ((FormMetadataValue)this.actual).getVersion();
        if (actualVersion != version) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, version, actualVersion});
        }
        return this;
    }
}

