/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import io.camunda.zeebe.protocol.record.value.deployment.Process;
import java.util.Arrays;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class ProcessAssert
extends AbstractObjectAssert<ProcessAssert, Process> {
    public ProcessAssert(Process actual) {
        super((Object)actual, ProcessAssert.class);
    }

    @CheckReturnValue
    public static ProcessAssert assertThat(Process actual) {
        return new ProcessAssert(actual);
    }

    public ProcessAssert hasBpmnProcessId(String bpmnProcessId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualBpmnProcessId = ((Process)this.actual).getBpmnProcessId();
        if (!Objects.areEqual((Object)actualBpmnProcessId, (Object)bpmnProcessId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, bpmnProcessId, actualBpmnProcessId});
        }
        return this;
    }

    public ProcessAssert hasChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Process)this.actual).getChecksum()).contains(checksum);
        return this;
    }

    public ProcessAssert hasOnlyChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Process)this.actual).getChecksum()).containsOnly(checksum);
        return this;
    }

    public ProcessAssert doesNotHaveChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Process)this.actual).getChecksum()).doesNotContain(checksum);
        return this;
    }

    public ProcessAssert hasNoChecksum() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have checksum but had :\n  <%s>";
        if (((Process)this.actual).getChecksum().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((Process)this.actual).getChecksum())});
        }
        return this;
    }

    public ProcessAssert isDuplicate() {
        this.isNotNull();
        if (!((Process)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual Process is duplicate but is not.", new Object[0]);
        }
        return this;
    }

    public ProcessAssert isNotDuplicate() {
        this.isNotNull();
        if (((Process)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual Process is not duplicate but is.", new Object[0]);
        }
        return this;
    }

    public ProcessAssert hasProcessDefinitionKey(long processDefinitionKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualProcessDefinitionKey = ((Process)this.actual).getProcessDefinitionKey();
        if (actualProcessDefinitionKey != processDefinitionKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, processDefinitionKey, actualProcessDefinitionKey});
        }
        return this;
    }

    public ProcessAssert hasResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Process)this.actual).getResource()).contains(resource);
        return this;
    }

    public ProcessAssert hasOnlyResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Process)this.actual).getResource()).containsOnly(resource);
        return this;
    }

    public ProcessAssert doesNotHaveResource(byte ... resource) {
        this.isNotNull();
        if (resource == null) {
            this.failWithMessage("Expecting resource parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((Process)this.actual).getResource()).doesNotContain(resource);
        return this;
    }

    public ProcessAssert hasNoResource() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resource but had :\n  <%s>";
        if (((Process)this.actual).getResource().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((Process)this.actual).getResource())});
        }
        return this;
    }

    public ProcessAssert hasResourceName(String resourceName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualResourceName = ((Process)this.actual).getResourceName();
        if (!Objects.areEqual((Object)actualResourceName, (Object)resourceName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceName, actualResourceName});
        }
        return this;
    }

    public ProcessAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((Process)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }

    public ProcessAssert hasVersion(int version) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualVersion = ((Process)this.actual).getVersion();
        if (actualVersion != version) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, version, actualVersion});
        }
        return this;
    }
}

