/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import java.util.Arrays;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Objects;

public class ProcessMetadataValueAssert
extends AbstractObjectAssert<ProcessMetadataValueAssert, ProcessMetadataValue> {
    public ProcessMetadataValueAssert(ProcessMetadataValue actual) {
        super((Object)actual, ProcessMetadataValueAssert.class);
    }

    @CheckReturnValue
    public static ProcessMetadataValueAssert assertThat(ProcessMetadataValue actual) {
        return new ProcessMetadataValueAssert(actual);
    }

    public ProcessMetadataValueAssert hasBpmnProcessId(String bpmnProcessId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting bpmnProcessId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualBpmnProcessId = ((ProcessMetadataValue)this.actual).getBpmnProcessId();
        if (!Objects.areEqual((Object)actualBpmnProcessId, (Object)bpmnProcessId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, bpmnProcessId, actualBpmnProcessId});
        }
        return this;
    }

    public ProcessMetadataValueAssert hasChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((ProcessMetadataValue)this.actual).getChecksum()).contains(checksum);
        return this;
    }

    public ProcessMetadataValueAssert hasOnlyChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((ProcessMetadataValue)this.actual).getChecksum()).containsOnly(checksum);
        return this;
    }

    public ProcessMetadataValueAssert doesNotHaveChecksum(byte ... checksum) {
        this.isNotNull();
        if (checksum == null) {
            this.failWithMessage("Expecting checksum parameter not to be null.", new Object[0]);
        }
        Assertions.assertThat((byte[])((ProcessMetadataValue)this.actual).getChecksum()).doesNotContain(checksum);
        return this;
    }

    public ProcessMetadataValueAssert hasNoChecksum() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have checksum but had :\n  <%s>";
        if (((ProcessMetadataValue)this.actual).getChecksum().length > 0) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, Arrays.toString(((ProcessMetadataValue)this.actual).getChecksum())});
        }
        return this;
    }

    public ProcessMetadataValueAssert isDuplicate() {
        this.isNotNull();
        if (!((ProcessMetadataValue)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual ProcessMetadataValue is duplicate but is not.", new Object[0]);
        }
        return this;
    }

    public ProcessMetadataValueAssert isNotDuplicate() {
        this.isNotNull();
        if (((ProcessMetadataValue)this.actual).isDuplicate()) {
            this.failWithMessage("\nExpecting that actual ProcessMetadataValue is not duplicate but is.", new Object[0]);
        }
        return this;
    }

    public ProcessMetadataValueAssert hasProcessDefinitionKey(long processDefinitionKey) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting processDefinitionKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        long actualProcessDefinitionKey = ((ProcessMetadataValue)this.actual).getProcessDefinitionKey();
        if (actualProcessDefinitionKey != processDefinitionKey) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, processDefinitionKey, actualProcessDefinitionKey});
        }
        return this;
    }

    public ProcessMetadataValueAssert hasResourceName(String resourceName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualResourceName = ((ProcessMetadataValue)this.actual).getResourceName();
        if (!Objects.areEqual((Object)actualResourceName, (Object)resourceName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceName, actualResourceName});
        }
        return this;
    }

    public ProcessMetadataValueAssert hasTenantId(String tenantId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tenantId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualTenantId = ((ProcessMetadataValue)this.actual).getTenantId();
        if (!Objects.areEqual((Object)actualTenantId, (Object)tenantId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tenantId, actualTenantId});
        }
        return this;
    }

    public ProcessMetadataValueAssert hasVersion(int version) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualVersion = ((ProcessMetadataValue)this.actual).getVersion();
        if (actualVersion != version) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, version, actualVersion});
        }
        return this;
    }
}

