/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.record.ExecuteCommandResponseDecoder;
import io.camunda.zeebe.protocol.record.ExecuteCommandResponseEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ExecuteCommandResponse
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ExecuteCommandResponseEncoder bodyEncoder = new ExecuteCommandResponseEncoder();
    private final ExecuteCommandResponseDecoder bodyDecoder = new ExecuteCommandResponseDecoder();
    private final DirectBuffer value = new UnsafeBuffer(0L, 0);
    private final DirectBuffer rejectionReason = new UnsafeBuffer(0L, 0);
    private int partitionId;
    private long key;
    private RecordType recordType;
    private ValueType valueType;
    private Intent intent;
    private RejectionType rejectionType;

    public ExecuteCommandResponse() {
        this.reset();
    }

    public ExecuteCommandResponse reset() {
        this.partitionId = ExecuteCommandResponseEncoder.partitionIdNullValue();
        this.key = ExecuteCommandResponseEncoder.keyNullValue();
        this.recordType = RecordType.NULL_VAL;
        this.valueType = ValueType.NULL_VAL;
        this.intent = Intent.UNKNOWN;
        this.rejectionType = RejectionType.NULL_VAL;
        this.value.wrap(0L, 0);
        this.rejectionReason.wrap(0L, 0);
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ExecuteCommandResponse setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public long getKey() {
        return this.key;
    }

    public ExecuteCommandResponse setKey(long key) {
        this.key = key;
        return this;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public ExecuteCommandResponse setRecordType(RecordType recordType) {
        this.recordType = recordType;
        return this;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public ExecuteCommandResponse setValueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public ExecuteCommandResponse setIntent(Intent intent) {
        this.intent = intent;
        return this;
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public ExecuteCommandResponse setRejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
        return this;
    }

    public DirectBuffer getValue() {
        return this.value;
    }

    public ExecuteCommandResponse setValue(DirectBuffer buffer, int offset, int length) {
        this.value.wrap(buffer, offset, length);
        return this;
    }

    public DirectBuffer getRejectionReason() {
        return this.rejectionReason;
    }

    public ExecuteCommandResponse setRejectionReason(DirectBuffer buffer, int offset, int length) {
        this.rejectionReason.wrap(buffer, offset, length);
        return this;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.reset();
        int frameEnd = offset + length;
        this.headerDecoder.wrap(buffer, offset);
        this.bodyDecoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.partitionId = this.bodyDecoder.partitionId();
        this.key = this.bodyDecoder.key();
        this.recordType = this.bodyDecoder.recordType();
        this.valueType = this.bodyDecoder.valueType();
        this.intent = Intent.fromProtocolValue((ValueType)this.valueType, (short)this.bodyDecoder.intent());
        this.rejectionType = this.bodyDecoder.rejectionType();
        offset += this.bodyDecoder.sbeBlockLength();
        int valueLength = this.bodyDecoder.valueLength();
        offset += ExecuteCommandResponseDecoder.valueHeaderLength();
        if (valueLength > 0) {
            this.value.wrap(buffer, offset, valueLength);
        }
        this.bodyDecoder.limit(offset += valueLength);
        int rejectionReasonLength = this.bodyDecoder.rejectionReasonLength();
        offset += ExecuteCommandResponseDecoder.rejectionReasonHeaderLength();
        if (rejectionReasonLength > 0) {
            this.rejectionReason.wrap(buffer, offset, rejectionReasonLength);
        }
        this.bodyDecoder.limit(offset += rejectionReasonLength);
        assert (this.bodyDecoder.limit() == frameEnd) : "Decoder read only to position " + this.bodyDecoder.limit() + " but expected " + frameEnd + " as final position";
    }

    public int getLength() {
        return 22 + ExecuteCommandResponseEncoder.valueHeaderLength() + this.value.capacity() + ExecuteCommandResponseEncoder.rejectionReasonHeaderLength() + this.rejectionReason.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.bodyEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength()).partitionId(this.partitionId).key(this.key).recordType(this.recordType).valueType(this.valueType).intent(this.intent.value()).rejectionType(this.rejectionType).putValue(this.value, 0, this.value.capacity()).putRejectionReason(this.rejectionReason, 0, this.rejectionReason.capacity());
    }
}

